/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.fluid;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.platform.services.FluidHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

public class FluidRenderHelper {
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;

    public static void drawFluid(GuiGraphics guiGraphics, int width, int height, FluidStack fluidStack, int capacity) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid.isSame(Fluids.EMPTY)) {
            return;
        }
        FluidRenderHelper.getStillFluidSprite(fluidStack).ifPresent(fluidStillSprite -> {
            int fluidColor = FluidRenderHelper.getColorTint(fluidStack);
            long amount = fluidStack.getAmount();
            long scaledAmount = amount * (long)height / (long)capacity;
            if (amount > 0L && scaledAmount < 1L) {
                scaledAmount = 1L;
            }
            if (scaledAmount > (long)height) {
                scaledAmount = height;
            }
            FluidRenderHelper.drawTiledSprite(guiGraphics, width, height, fluidColor, scaledAmount, fluidStillSprite);
        });
    }

    private static int getColorTint(FluidStack ingredient) {
        Fluid fluid = ingredient.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor(ingredient);
    }

    private static Optional<TextureAtlasSprite> getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(fluidStill);
        return Optional.of(sprite).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation());
    }

    private static void drawTiledSprite(GuiGraphics guiGraphics, int tiledWidth, int tiledHeight, int color, long scaledAmount, TextureAtlasSprite sprite) {
        Matrix4f matrix = guiGraphics.pose().last().pose();
        FluidRenderHelper.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    FluidRenderHelper.drawTextureWithMasking((MultiBufferSource)guiGraphics.bufferSource, matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(MultiBufferSource bufferSource, Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.blockScreenEffect((ResourceLocation)textureSprite.atlasLocation()));
        vertexconsumer.addVertex(matrix, xCoord, yCoord + 16.0f, zLevel).setUv(uMin, vMax);
        vertexconsumer.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).setUv(uMax, vMax);
        vertexconsumer.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).setUv(uMax, vMin);
        vertexconsumer.addVertex(matrix, xCoord, yCoord + (float)maskTop, zLevel).setUv(uMin, vMin);
    }

    public static List<Component> getTooltip(FluidStack fluidStack, int capacity, TooltipFlag tooltipFlag, FluidHelper.TooltipMode tooltipMode) {
        Fluid fluidType = fluidStack.getFluid();
        try {
            if (fluidType.isSame(Fluids.EMPTY)) {
                return new ArrayList<Component>();
            }
            List<Component> tooltip = FluidRenderHelper.getTooltipBase(fluidStack, tooltipFlag);
            long amount = fluidStack.getAmount();
            long milliBuckets = amount * 1000L / 1000L;
            if (tooltipMode == FluidHelper.TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
                MutableComponent amountString = Component.translatable((String)"tooltip.modonomicon.fluid.amount_and_capacity", (Object[])new Object[]{milliBuckets, capacity});
                tooltip.add((Component)amountString.withStyle(ChatFormatting.GRAY));
            } else if (tooltipMode == FluidHelper.TooltipMode.SHOW_AMOUNT) {
                MutableComponent amountString = Component.translatable((String)"tooltip.modonomicon.fluid.amount", (Object[])new Object[]{milliBuckets});
                tooltip.add((Component)amountString.withStyle(ChatFormatting.GRAY));
            }
            return tooltip;
        }
        catch (RuntimeException e) {
            Component displayName = fluidStack.getDisplayName();
            Modonomicon.LOG.error("Failed to get tooltip for fluid: " + String.valueOf(displayName), (Throwable)e);
            return new ArrayList<Component>();
        }
    }

    private static List<Component> getTooltipBase(FluidStack fluidStack, TooltipFlag tooltipFlag) {
        ResourceLocation resourceLocation;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Fluid fluid = fluidStack.getFluid();
        if (fluid.isSame(Fluids.EMPTY)) {
            return tooltip;
        }
        Component displayName = fluidStack.getDisplayName();
        tooltip.add(displayName);
        if (tooltipFlag.isAdvanced() && (resourceLocation = ForgeRegistries.FLUIDS.getKey((Object)fluid)) != null) {
            MutableComponent advancedId = Component.literal((String)resourceLocation.toString()).withStyle(ChatFormatting.DARK_GRAY);
            tooltip.add((Component)advancedId);
        }
        return tooltip;
    }
}

