/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry;

import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.ArrowButton;
import com.klikli_dev.modonomicon.client.gui.book.button.BackButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ExitButton;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BookEntrySinglePageScreen
extends BookEntryScreen {
    public static final int SINGLE_PAGE_BOOK_BACKGROUND_WIDTH = 145;
    public static final int SINGLE_PAGE_BOOK_BACKGROUND_HEIGHT = 178;
    protected final ResourceLocation singlePageTexture;
    private BookPage page;
    private BookPageRenderer<?> pageRenderer;

    public BookEntrySinglePageScreen(BookParentScreen parentScreen, BookContentEntry entry) {
        super(parentScreen, entry);
        this.singlePageTexture = entry.getBook().getSinglePageTexture();
    }

    public static void renderSinglePageBookBackground(GuiGraphics guiGraphics, ResourceLocation bookContentTexture) {
        int x = 0;
        int y = 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(RenderType::guiTextured, bookContentTexture, x, y, 0.0f, 0.0f, 145, 178, 256, 256);
    }

    @Override
    protected void initNavigationButtons() {
        this.bookLeft = (this.width - 145) / 2;
        this.bookTop = (this.height - 178) / 2;
        this.addRenderableWidget(new ArrowButton(this, this.bookLeft - 4, this.bookTop + 178 - 6, true, () -> this.canSeeArrowButton(true), this::handleArrowButton));
        this.addRenderableWidget(new ArrowButton(this, this.bookLeft + 145 - 14, this.bookTop + 178 - 6, false, () -> this.canSeeArrowButton(false), this::handleArrowButton));
        if (this.addExitButton) {
            this.addRenderableWidget(new ExitButton(this, this.bookLeft + 145 - 10, this.bookTop - 2, this::handleExitButton));
        }
        this.addRenderableWidget(new BackButton(this, this.width / 2 - 9, this.bookTop + 178 - 4));
    }

    @Override
    protected int getOpenPagesIndexForPage(int pageIndex) {
        return pageIndex;
    }

    @Override
    protected int getPageForOpenPagesIndex(int openPagesIndex) {
        return openPagesIndex;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.unlockedPages.size();
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.getBook());
            }
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        return this.getClickedComponentStyleAtForPage(this.pageRenderer, pMouseX, pMouseY);
    }

    @Override
    protected boolean mouseClickedPage(double pMouseX, double pMouseY, int pButton) {
        return this.clickPage(this.pageRenderer, pMouseX, pMouseY, pButton);
    }

    @Override
    protected void beginDisplayPages() {
        int pageIndex;
        if (this.pageRenderer != null) {
            this.pageRenderer.onEndDisplayPage(this);
        }
        BookPage bookPage = this.page = (pageIndex = this.openPagesIndex) < this.unlockedPages.size() ? (BookPage)this.unlockedPages.get(pageIndex) : null;
        if (this.page != null) {
            this.pageRenderer = PageRendererRegistry.getPageRenderer(this.page.getType()).create(this.page);
            this.pageRenderer.onBeginDisplayPage(this, 12, 15);
        } else {
            this.pageRenderer = null;
        }
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.resetTooltip();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -1300.0f);
        this.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        BookEntrySinglePageScreen.renderSinglePageBookBackground(guiGraphics, this.singlePageTexture);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderPage(guiGraphics, this.pageRenderer, pMouseX, pMouseY, pPartialTick);
        guiGraphics.pose().popPose();
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }
}

