/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.LinkHandler;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.integration.jei.ModonomiconJeiIntegration;
import com.mojang.brigadier.StringReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemLinkHandler
extends LinkHandler {
    private final ItemParser itemParser;

    public ItemLinkHandler(BookEntryScreen screen) {
        super(screen);
        this.itemParser = new ItemParser((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
    }

    @Override
    public LinkHandler.ClickResult handleClick(@NotNull Style pStyle) {
        ClickEvent event = pStyle.getClickEvent();
        if (event == null) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        if (event.action() != ClickEvent.Action.OPEN_FILE || !(event instanceof ClickEvent.OpenFile)) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        ClickEvent.OpenFile openFile = (ClickEvent.OpenFile)event;
        if (!ItemLinkRenderer.isItemLink(openFile.path())) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        if (!ModonomiconJeiIntegration.get().isLoaded()) {
            return LinkHandler.ClickResult.FAILURE;
        }
        ItemStack itemStack = ItemStack.EMPTY;
        try {
            String itemId = openFile.path().substring(ItemLinkRenderer.PROTOCOL_ITEM_LENGTH);
            StringReader reader = new StringReader(itemId);
            ItemParser.ItemResult itemResult = this.itemParser.parse(reader);
            ItemInput itemInput = new ItemInput(itemResult.item(), itemResult.components());
            itemStack = itemInput.createItemStack(1, false);
        }
        catch (Exception e) {
            Modonomicon.LOG.error("Failed to parse item link: {}", (Object)openFile.path(), (Object)e);
            return LinkHandler.ClickResult.FAILURE;
        }
        ItemStack finalItemStack = itemStack;
        BookGuiManager.get().keepMousePosition(() -> {
            BookGuiManager.get().closeScreenStack(this.screen());
            if (Screen.hasShiftDown()) {
                ModonomiconJeiIntegration.get().showUses(finalItemStack);
            } else {
                ModonomiconJeiIntegration.get().showRecipe(finalItemStack);
            }
        });
        return LinkHandler.ClickResult.SUCCESS;
    }
}

