/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.node;

import com.klikli_dev.modonomicon.api.events.EntryClickedEvent;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.book.BookEntryParent;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.CategoryVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.entry.EntryConnectionRenderer;
import com.klikli_dev.modonomicon.client.gui.book.entry.EntryDisplayState;
import com.klikli_dev.modonomicon.client.gui.book.node.BookParentNodeScreen;
import com.klikli_dev.modonomicon.events.ModonomiconEvents;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class BookCategoryNodeScreen
implements BookCategoryScreen {
    public static final int ENTRY_GRID_SCALE = 30;
    public static final int ENTRY_GAP = 2;
    public static final int ENTRY_HEIGHT = 26;
    public static final int ENTRY_WIDTH = 26;
    private final BookParentNodeScreen bookParentScreen;
    private final BookCategory category;
    private final EntryConnectionRenderer connectionRenderer;
    private float scrollX = 0.0f;
    private float scrollY = 0.0f;
    private boolean isScrolling;
    private float targetZoom;
    private float currentZoom;

    public BookCategoryNodeScreen(BookParentNodeScreen bookOverviewScreen, BookCategory category) {
        this.bookParentScreen = bookOverviewScreen;
        this.category = category;
        this.connectionRenderer = new EntryConnectionRenderer(category.getEntryTextures());
        this.currentZoom = this.targetZoom = 0.7f;
    }

    @Override
    public BookCategory getCategory() {
        return this.category;
    }

    public float getXOffset() {
        return (float)this.bookParentScreen.getInnerWidth() / 2.0f * (1.0f / this.currentZoom) - this.scrollX / 2.0f;
    }

    public float getYOffset() {
        return (float)this.bookParentScreen.getInnerHeight() / 2.0f * (1.0f / this.currentZoom) - this.scrollY / 2.0f;
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (ClientServices.CLIENT_CONFIG.enableSmoothZoom()) {
            float diff = this.targetZoom - this.currentZoom;
            this.currentZoom += Math.min(pPartialTick * 0.6666667f, 1.0f) * diff;
        } else {
            this.currentZoom = this.targetZoom;
        }
        int innerX = this.bookParentScreen.getInnerX();
        int innerY = this.bookParentScreen.getInnerY();
        int innerWidth = this.bookParentScreen.getInnerWidth();
        int innerHeight = this.bookParentScreen.getInnerHeight();
        guiGraphics.enableScissor(innerX, innerY, innerX + innerWidth - 1, innerY + innerHeight - 1);
        this.renderEntries(guiGraphics, pMouseX, pMouseY);
        guiGraphics.disableScissor();
    }

    public void zoom(double delta) {
        float step = 1.2f;
        if (delta < 0.0 && (double)this.targetZoom > 0.5 || delta > 0.0 && this.targetZoom < 1.0f) {
            this.targetZoom *= delta > 0.0 ? step : 1.0f / step;
        }
        if (this.targetZoom > 1.0f) {
            this.targetZoom = 1.0f;
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else {
            this.scroll(pDragX * 1.5, pDragY * 1.5);
        }
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayStyle = this.getEntryDisplayState(entry);
            if (!this.isEntryHovered(entry, xOffset, yOffset, (int)pMouseX, (int)pMouseY)) continue;
            EntryClickedEvent event = new EntryClickedEvent(this.category.getBook().getId(), entry.getId(), pMouseX, pMouseY, pButton, displayStyle);
            if (ModonomiconEvents.client().entryClicked(event)) {
                return true;
            }
            if (displayStyle != EntryDisplayState.UNLOCKED) continue;
            BookGuiManager.get().openEntry(entry, BookAddress.defaultFor(entry));
            return true;
        }
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics) {
        float yScale;
        float scale;
        int innerX = this.bookParentScreen.getInnerX();
        int innerY = this.bookParentScreen.getInnerY();
        int innerWidth = this.bookParentScreen.getInnerWidth();
        int innerHeight = this.bookParentScreen.getInnerHeight();
        int backgroundWidth = this.category.getBackgroundWidth();
        int backgroundHeight = this.category.getBackgroundHeight();
        int MAX_SCROLL = Math.max(backgroundWidth, backgroundHeight);
        float backgroundTextureZoomMultiplier = this.category.getBackgroundTextureZoomMultiplier();
        float xScale = (float)MAX_SCROLL * 2.0f / ((float)MAX_SCROLL + (float)this.bookParentScreen.getFrameThicknessW() - (float)this.bookParentScreen.getFrameWidth());
        float xOffset = xScale == (scale = Math.max(xScale, yScale = (float)MAX_SCROLL * 2.0f / ((float)MAX_SCROLL + (float)this.bookParentScreen.getFrameThicknessH() - (float)this.bookParentScreen.getFrameHeight()))) ? 0.0f : ((float)MAX_SCROLL - ((float)innerWidth + (float)MAX_SCROLL * 2.0f / scale)) / 2.0f;
        float yOffset = yScale == scale ? 0.0f : ((float)MAX_SCROLL - ((float)innerHeight + (float)MAX_SCROLL * 2.0f / scale)) / 2.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.category.getBackgroundParallaxLayers().isEmpty()) {
            this.category.getBackgroundParallaxLayers().forEach(layer -> this.renderBackgroundParallaxLayer(guiGraphics, (BookCategoryBackgroundParallaxLayer)layer, innerX, innerY, innerWidth, innerHeight, this.scrollX, this.scrollY, scale, xOffset, yOffset, this.currentZoom, backgroundWidth, backgroundHeight, backgroundTextureZoomMultiplier));
        } else {
            guiGraphics.blit(RenderType::guiTextured, this.category.getBackground(), innerX, innerY, (this.scrollX + (float)MAX_SCROLL) / scale + xOffset, (this.scrollY + (float)MAX_SCROLL) / scale + yOffset, innerWidth, innerHeight, (int)((float)backgroundHeight * backgroundTextureZoomMultiplier), (int)((float)backgroundWidth * backgroundTextureZoomMultiplier));
        }
    }

    public void renderBackgroundParallaxLayer(GuiGraphics guiGraphics, BookCategoryBackgroundParallaxLayer layer, int x, int y, int width, int height, float scrollX, float scrollY, float parallax, float xOffset, float yOffset, float zoom, int backgroundWidth, int backgroundHeight, float backgroundTextureZoomMultiplier) {
        float parallax1 = parallax / layer.getSpeed();
        if (layer.getVanishZoom() == -1.0f || layer.getVanishZoom() > zoom) {
            guiGraphics.blit(RenderType::guiTextured, layer.getBackground(), x, y, (scrollX + (float)this.getCategory().getMaxScrollX()) / parallax1 + xOffset, (scrollY + (float)this.getCategory().getMaxScrollY()) / parallax1 + yOffset, width, height, (int)((float)backgroundHeight * backgroundTextureZoomMultiplier), (int)((float)backgroundWidth * backgroundTextureZoomMultiplier));
        }
    }

    private void renderEntries(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(this.currentZoom, this.currentZoom, 1.0f);
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayState = this.getEntryDisplayState(entry);
            boolean isHovered = this.isEntryHovered(entry, xOffset, yOffset, mouseX, mouseY);
            if (displayState == EntryDisplayState.HIDDEN) continue;
            int texX = entry.getEntryBackgroundVIndex() * 26;
            int texY = entry.getEntryBackgroundUIndex() * 26;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(xOffset, yOffset, 0.0f);
            guiGraphics.pose().translate(0.0f, 0.0f, 10.0f);
            if (displayState == EntryDisplayState.LOCKED) {
                RenderSystem.setShaderColor((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
            } else if (isHovered) {
                RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            }
            guiGraphics.blit(RenderType::guiTextured, this.category.getEntryTextures(), entry.getX() * 30 + 2, entry.getY() * 30 + 2, (float)texX, (float)texY, 26, 26, 256, 256);
            guiGraphics.pose().pushPose();
            entry.getIcon().render(guiGraphics, entry.getX() * 30 + 2 + 5, entry.getY() * 30 + 2 + 5);
            guiGraphics.pose().popPose();
            if (displayState == EntryDisplayState.UNLOCKED && !BookUnlockStateManager.get().isReadFor((Player)Minecraft.getInstance().player, entry)) {
                int U = 350;
                int V = 19;
                int width = 11;
                int height = 11;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 11.0f);
                BookContentRenderer.drawFromContentTexture(RenderType::guiTexturedOverlay, guiGraphics, this.bookParentScreen.getBook(), entry.getX() * 30 + 2 + 16 + 2, entry.getY() * 30 + 2 - 2, 350 + (isHovered ? 11 : 0), 19, 11, 11);
                guiGraphics.pose().popPose();
            }
            guiGraphics.pose().popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderConnections(guiGraphics, entry, xOffset, yOffset);
        }
        guiGraphics.pose().popPose();
    }

    public void renderEntryTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayState = this.getEntryDisplayState(entry);
            if (displayState == EntryDisplayState.HIDDEN) continue;
            this.renderTooltip(guiGraphics, entry, displayState, xOffset, yOffset, mouseX, mouseY);
        }
    }

    private boolean isEntryHovered(BookEntry entry, float xOffset, float yOffset, int mouseX, int mouseY) {
        int x = (int)(((float)(entry.getX() * 30) + xOffset + 2.0f) * this.currentZoom);
        int y = (int)(((float)(entry.getY() * 30) + yOffset + 2.0f) * this.currentZoom);
        int innerX = this.bookParentScreen.getInnerX();
        int innerY = this.bookParentScreen.getInnerY();
        int innerWidth = this.bookParentScreen.getInnerWidth();
        int innerHeight = this.bookParentScreen.getInnerHeight();
        return mouseX >= x && (float)mouseX <= (float)x + 26.0f * this.currentZoom && mouseY >= y && (float)mouseY <= (float)y + 26.0f * this.currentZoom && mouseX >= innerX && mouseX <= innerX + innerWidth && mouseY >= innerY && mouseY <= innerY + innerHeight;
    }

    private void renderTooltip(GuiGraphics guiGraphics, BookEntry entry, EntryDisplayState displayState, float xOffset, float yOffset, int mouseX, int mouseY) {
        if (this.isEntryHovered(entry, xOffset, yOffset, mouseX, mouseY)) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (displayState == EntryDisplayState.LOCKED) {
                tooltip.addAll(entry.getCondition().getTooltip((Player)Minecraft.getInstance().player, BookConditionEntryContext.of(this.bookParentScreen.getBook(), entry)));
            } else if (displayState == EntryDisplayState.UNLOCKED) {
                tooltip.add(Component.translatable((String)entry.getName()).withStyle(ChatFormatting.BOLD));
                if (!entry.getDescription().isEmpty()) {
                    tooltip.add(Component.translatable((String)entry.getDescription()));
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderConnections(GuiGraphics guiGraphics, BookEntry entry, float xOffset, float yOffset) {
        for (BookEntryParent bookEntryParent : entry.getParents()) {
            EntryDisplayState parentDisplayState = this.getEntryDisplayState(bookEntryParent.getEntry());
            if (parentDisplayState == EntryDisplayState.HIDDEN) continue;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(xOffset, yOffset, 0.0f);
            this.connectionRenderer.render(guiGraphics, entry, bookEntryParent);
            guiGraphics.pose().popPose();
        }
    }

    private void scroll(double pDragX, double pDragY) {
        this.scrollX = (float)Mth.clamp((double)((double)this.scrollX - pDragX), (double)(-this.getCategory().getMaxScrollX()), (double)this.getCategory().getMaxScrollX());
        this.scrollY = (float)Mth.clamp((double)((double)this.scrollY - pDragY), (double)(-this.getCategory().getMaxScrollY()), (double)this.getCategory().getMaxScrollY());
    }

    @Override
    public void loadState(CategoryVisualState state) {
        this.scrollX = state.scrollX;
        this.scrollY = state.scrollY;
        this.targetZoom = state.targetZoom;
        this.currentZoom = state.targetZoom;
    }

    @Override
    public void saveState(CategoryVisualState state) {
        state.scrollX = this.scrollX;
        state.scrollY = this.scrollY;
        state.targetZoom = this.targetZoom;
    }

    @Override
    public void onDisplay() {
    }

    @Override
    public void onClose() {
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 256) {
            BookGuiManager.get().closeScreenStack(this);
            return true;
        }
        return false;
    }
}

