/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.page.BookEntityPage;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.util.EntityUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class BookEntityPageRenderer
extends BookPageRenderer<BookEntityPage>
implements PageWithTextRenderer {
    private Entity entity;
    private boolean errored;
    private float renderScale;
    private float renderOffset;

    public BookEntityPageRenderer(BookEntityPage page) {
        super(page);
    }

    public static void renderEntity(GuiGraphics guiGraphics, Entity entity, Level world, float x, float y, float rotation, float renderScale, float offset) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x, y, 50.0f);
        guiGraphics.pose().scale(renderScale, renderScale, renderScale);
        guiGraphics.pose().translate(0.0f, offset, 0.0f);
        guiGraphics.pose().mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        guiGraphics.pose().mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        EntityRenderDispatcher erd = Minecraft.getInstance().getEntityRenderDispatcher();
        erd.setRenderShadow(false);
        guiGraphics.drawSpecial(bufferSource -> erd.render(entity, 0.0, 0.0, 0.0, 1.0f, guiGraphics.pose(), bufferSource, 0xF000F0));
        erd.setRenderShadow(true);
        guiGraphics.pose().popPose();
    }

    private void loadEntity(Level world) {
        if (!(this.errored || this.entity != null && this.entity.isAlive())) {
            try {
                Function<Level, Entity> entityLoader = EntityUtil.getEntityLoader(((BookEntityPage)this.page).getEntityId());
                this.entity = entityLoader.apply(world);
                float width = this.entity.getBbWidth();
                float height = this.entity.getBbHeight();
                float entitySize = Math.max(1.0f, Math.max(width, height));
                this.renderScale = 100.0f / entitySize * 0.8f * ((BookEntityPage)this.getPage()).getScale();
                this.renderOffset = Math.max(height, entitySize) * 0.5f + ((BookEntityPage)this.getPage()).getOffset();
            }
            catch (Exception e) {
                this.errored = true;
                Modonomicon.LOG.error("Failed to load entity", (Throwable)e);
            }
        }
    }

    @Override
    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.loadEntity((Level)Minecraft.getInstance().level);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        Style style;
        if (!((BookEntityPage)this.page).getEntityName().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookEntityPage)this.page).getEntityName(), false, 62, 0);
        }
        int textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, ((BookEntityPage)this.getPage()).getText(), 0, textY, 124, 155 - textY);
        int x = 9;
        int y = 7;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookContentRenderer.drawFromContentTexture(RenderType::guiTexturedOverlay, guiGraphics, ((BookEntityPage)this.getPage()).getBook(), x, y, 405, 149, 106, 106);
        if (this.errored) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"modonomicon.gui.page.entity.loading_error"), 58, 60, 0xFF0000, true);
        }
        if (this.entity != null) {
            float rotation = ((BookEntityPage)this.page).doesRotate() ? ClientTicks.total : ((BookEntityPage)this.page).getDefaultRotation();
            BookEntityPageRenderer.renderEntity(guiGraphics, this.entity, (Level)Minecraft.getInstance().level, 58.0f, 60.0f, rotation, this.renderScale, this.renderOffset);
        }
        if ((style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style titleStyle;
            if (!((BookEntityPage)this.page).getEntityName().isEmpty() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookEntityPage)this.page).getEntityName(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            int x = this.parentScreen.getBook().getBookTextOffsetX();
            int y = this.getTextY() + this.parentScreen.getBook().getBookTextOffsetY();
            int width = 124 + this.parentScreen.getBook().getBookTextOffsetWidth() - x;
            int height = 155 + this.parentScreen.getBook().getBookTextOffsetHeight() - y;
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookEntityPage)this.page).getText(), x, y, width, height, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    @Override
    public int getTextY() {
        return 115;
    }
}

