/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.button.VisualizeButton;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class BookMultiblockPageRenderer
extends BookPageRenderer<BookMultiblockPage>
implements PageWithTextRenderer {
    private static final RandomSource randomSource = RandomSource.createNewThreadLocalInstance();
    private final Map<BlockPos, BlockEntity> blockEntityCache = new Object2ObjectOpenHashMap();
    private final Set<BlockEntity> erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
    protected Pair<BlockPos, Collection<Multiblock.SimulateResult>> multiblockSimulation;
    protected Button visualizeButton;

    public BookMultiblockPageRenderer(BookMultiblockPage page) {
        super(page);
    }

    public void handleButtonVisualize(Button button) {
        MultiblockPreviewRenderer.setMultiblock(((BookMultiblockPage)this.page).getMultiblock(), ((BookMultiblockPage)this.page).getMultiblockName().getComponent(), true);
        BookGuiManager.get().closeScreenStack(this.parentScreen);
    }

    private void renderMultiblock(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        BlockPos pos = BlockPos.ZERO;
        Rotation facingRotation = Rotation.NONE;
        ((BookMultiblockPage)this.page).getMultiblock().setLevel((Level)level);
        if (((BookMultiblockPage)this.page).getMultiblock().isSymmetrical()) {
            facingRotation = Rotation.NONE;
        }
        Vec3i size = ((BookMultiblockPage)this.page).getMultiblock().getSize();
        int sizeX = size.getX();
        int sizeY = size.getY();
        int sizeZ = size.getZ();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 62;
        int yPos = 60;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)xPos, (float)yPos, 100.0f);
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.pose().translate(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        guiGraphics.pose().mulPose((Quaternionfc)Axis.XP.rotationDegrees(-30.0f));
        rotMat.rotate((Quaternionfc)Axis.XP.rotationDegrees(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parentScreen.getTicksInBook() * 0.5f;
        if (!Screen.hasShiftDown()) {
            time += ClientTicks.partialTicks;
        }
        guiGraphics.pose().translate(-offX, 0.0f, -offZ);
        guiGraphics.pose().mulPose((Quaternionfc)Axis.YP.rotationDegrees(time));
        rotMat.rotate((Quaternionfc)Axis.YP.rotationDegrees(-time));
        guiGraphics.pose().mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
        rotMat.rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        guiGraphics.pose().translate(offX, 0.0f, offZ);
        rotMat.transform(eye);
        eye.div(eye.w);
        Vec3 eye3 = new Vec3((double)eye.x(), (double)eye.y(), (double)eye.z());
        MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
        BlockPos checkPos = null;
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockRes = (BlockHitResult)hitResult;
            checkPos = blockRes.getBlockPos().relative(blockRes.getDirection());
        }
        guiGraphics.pose().pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().translate(0.0f, 0.0f, -1.0f);
        for (Multiblock.SimulateResult r : (Collection)this.multiblockSimulation.getSecond()) {
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            BlockState renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).rotate(facingRotation);
            this.renderBlock(buffers, level, renderState, r.getWorldPosition(), alpha, guiGraphics.pose());
            Block block = renderState.getBlock();
            if (!(block instanceof EntityBlock)) continue;
            EntityBlock eb = (EntityBlock)block;
            BlockEntity be = this.blockEntityCache.compute(r.getWorldPosition().immutable(), (p, cachedBe) -> {
                if (cachedBe != null && !cachedBe.getType().isValid(renderState)) {
                    return eb.newBlockEntity(p, renderState);
                }
                return cachedBe != null ? cachedBe : eb.newBlockEntity(p, renderState);
            });
            if (be == null || this.erroredBlockEntities.contains(be)) continue;
            be.setLevel((Level)mc.level);
            be.setBlockState(renderState);
            guiGraphics.pose().pushPose();
            BlockPos bePos = r.getWorldPosition();
            guiGraphics.pose().translate((float)bePos.getX(), (float)bePos.getY(), (float)bePos.getZ());
            try {
                BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
                if (renderer != null) {
                    renderer.render(be, ClientTicks.partialTicks, guiGraphics.pose(), (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.NO_OVERLAY, eye3);
                }
            }
            catch (Exception e) {
                this.erroredBlockEntities.add(be);
                Modonomicon.LOG.error("Error rendering block entity", (Throwable)e);
            }
            guiGraphics.pose().popPose();
        }
        guiGraphics.pose().popPose();
        buffers.endBatch();
        guiGraphics.pose().popPose();
    }

    private void renderBlock(MultiBufferSource.BufferSource buffers, ClientLevel level, BlockState state, BlockPos pos, float alpha, PoseStack ps) {
        if (pos != null) {
            ps.pushPose();
            ps.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            ClientServices.MULTIBLOCK.renderBlock(state, pos, ((BookMultiblockPage)this.page).getMultiblock(), ps, (MultiBufferSource)buffers, randomSource);
            ps.popPose();
        }
    }

    @Override
    public int getTextY() {
        return 115;
    }

    @Override
    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.multiblockSimulation = ((BookMultiblockPage)this.page).getMultiblock().simulate(null, BlockPos.ZERO, Rotation.NONE, true, true);
        if (((BookMultiblockPage)this.page).showVisualizeButton()) {
            this.visualizeButton = new VisualizeButton(this.parentScreen, 13, 102, this::handleButtonVisualize);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        int x = 9;
        int y = 7;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookContentRenderer.drawFromContentTexture(RenderType::guiTexturedOverlay, guiGraphics, ((BookMultiblockPage)this.page).getBook(), x, y, 405, 149, 106, 106);
        if (!((BookMultiblockPage)this.page).getMultiblockName().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookMultiblockPage)this.page).getMultiblockName(), false, 62, 0);
        }
        this.renderMultiblock(guiGraphics);
        int textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, ((BookMultiblockPage)this.page).getText(), 0, textY, 124, 155 - textY);
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style multiblockNameStyle = this.getClickedComponentStyleAtForTitle(((BookMultiblockPage)this.page).getMultiblockName(), 62, 0, pMouseX, pMouseY);
            if (multiblockNameStyle != null) {
                return multiblockNameStyle;
            }
            int x = this.parentScreen.getBook().getBookTextOffsetX();
            int y = this.getTextY() + this.parentScreen.getBook().getBookTextOffsetY();
            int width = 124 + this.parentScreen.getBook().getBookTextOffsetWidth() - x;
            int height = 155 + this.parentScreen.getBook().getBookTextOffsetHeight() - y;
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookMultiblockPage)this.page).getText(), x, y, width, height, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }
}

