/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.book.page.BookSpotlightPage;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class BookSpotlightPageRenderer
extends BookPageRenderer<BookSpotlightPage>
implements PageWithTextRenderer {
    public static final int ITEM_X = 54;
    public static final int ITEM_Y = 15;

    public BookSpotlightPageRenderer(BookSpotlightPage page) {
        super(page);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        if (((BookSpotlightPage)this.page).hasTitle()) {
            this.renderTitle(guiGraphics, ((BookSpotlightPage)this.page).getTitle(), false, 62, 0);
        }
        int textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, ((BookSpotlightPage)this.getPage()).getText(), 0, textY, 124, 155 - textY);
        int w = 66;
        int h = 26;
        guiGraphics.blit(RenderType::guiTexturedOverlay, ((BookSpotlightPage)this.page).getBook().getCraftingTexture(), 62 - w / 2, 10, 0.0f, (float)(128 - h), w, h, 128, 256);
        ((BookSpotlightPage)this.page).getItem().ifRight(ingredient -> this.parentScreen.renderIngredient(guiGraphics, 54, 15, mouseX, mouseY, (Ingredient)ingredient));
        ((BookSpotlightPage)this.page).getItem().ifLeft(itemStack -> this.parentScreen.renderItemStack(guiGraphics, 54, 15, mouseX, mouseY, (ItemStack)itemStack));
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style titleStyle;
            if (((BookSpotlightPage)this.page).hasTitle() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookSpotlightPage)this.page).getTitle(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            int x = this.parentScreen.getBook().getBookTextOffsetX();
            int y = this.getTextY() + this.parentScreen.getBook().getBookTextOffsetY();
            int width = 124 + this.parentScreen.getBook().getBookTextOffsetWidth() - x;
            int height = 155 + this.parentScreen.getBook().getBookTextOffsetHeight() - y;
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookSpotlightPage)this.page).getText(), x, y, width, height, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    @Override
    public int getTextY() {
        return 40;
    }
}

