/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ModonomiconModelProvider
extends ModelProvider {
    public ModonomiconModelProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public static void generateFlatItem(Item item, String texture, ItemModelGenerators itemModelGenerator) {
        itemModelGenerator.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)ModonomiconModelProvider.createFlatItemModel(item, texture, itemModelGenerator)));
    }

    public static ResourceLocation createFlatItemModel(Item item, String texture, ItemModelGenerators itemModelGenerator) {
        return ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((ResourceLocation)Modonomicon.loc("item/" + texture)), itemModelGenerator.modelOutput);
    }

    @NotNull
    protected Stream<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> "modonomicon".equals(block.builtInRegistryHolder().key().location().getNamespace()));
    }

    @NotNull
    protected Stream<Item> getKnownItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> "modonomicon".equals(item.builtInRegistryHolder().key().location().getNamespace()));
    }

    @NotNull
    protected ItemModelGenerators getItemModelGenerators(@NotNull ModelProvider.ItemInfoCollector items, @NotNull ModelProvider.SimpleModelCollector models) {
        return new ItemModelGenerators(this, (ItemModelOutput)items, (BiConsumer)models){

            public void run() {
                ModonomiconModelProvider.generateFlatItem(ItemRegistry.MODONOMICON.get(), "modonomicon_purple", this);
                ModonomiconModelProvider.generateFlatItem(ItemRegistry.MODONOMICON_BLUE.get(), "modonomicon_blue", this);
                ModonomiconModelProvider.generateFlatItem(ItemRegistry.MODONOMICON_GREEN.get(), "modonomicon_green", this);
                ModonomiconModelProvider.generateFlatItem(ItemRegistry.MODONOMICON_PURPLE.get(), "modonomicon_purple", this);
                ModonomiconModelProvider.generateFlatItem(ItemRegistry.MODONOMICON_RED.get(), "modonomicon_red", this);
                ModonomiconModelProvider.generateFlatItem(ItemRegistry.LEAFLET.get(), "leaflet", this);
            }
        };
    }

    @NotNull
    protected BlockModelGenerators getBlockModelGenerators(@NotNull ModelProvider.BlockStateGeneratorCollector blocks, @NotNull ModelProvider.ItemInfoCollector items, @NotNull ModelProvider.SimpleModelCollector models) {
        return new BlockModelGenerators(this, (Consumer)blocks, (ItemModelOutput)items, (BiConsumer)models){

            public void run() {
            }
        };
    }
}

