/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.fluid;

import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ForgeFluidHolder
implements FluidHolder {
    protected FluidStack fluidStack;

    public ForgeFluidHolder(FluidStack stack) {
        this.fluidStack = stack.copy();
    }

    public ForgeFluidHolder(FluidHolder fluid) {
        this(fluid.getFluid(), fluid.getAmount(), fluid.getComponents());
    }

    public ForgeFluidHolder(Fluid fluid, int amount, CompoundTag tag) {
        this.fluidStack = new FluidStack(fluid, amount, tag);
    }

    public ForgeFluidHolder(Holder<Fluid> fluid, int amount, DataComponentPatch patch) {
        this.fluidStack = new FluidStack((Fluid)fluid.value(), amount, (CompoundTag)DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)patch).getOrThrow());
    }

    public static FluidStack toStack(FluidHolder fluidHolder) {
        return new FluidStack((Fluid)fluidHolder.getFluid().value(), fluidHolder.getAmount(), (CompoundTag)DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)fluidHolder.getComponents()).getOrThrow());
    }

    public static ForgeFluidHolder empty() {
        return new ForgeFluidHolder(FluidStack.EMPTY);
    }

    @Override
    public Holder<Fluid> getFluid() {
        return this.fluidStack.getFluid().builtInRegistryHolder();
    }

    @Override
    public boolean isEmpty() {
        return this.fluidStack.isEmpty();
    }

    @Override
    public int getAmount() {
        return this.fluidStack.getAmount();
    }

    @Override
    public void setAmount(int amount) {
        this.fluidStack.setAmount(amount);
    }

    @Override
    public DataComponentPatch getComponents() {
        return (DataComponentPatch)((Pair)DataComponentPatch.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)this.fluidStack.getTag()).getOrThrow()).getFirst();
    }

    @Override
    public FluidHolder copy() {
        return new ForgeFluidHolder((Fluid)this.getFluid().value(), this.getAmount(), this.fluidStack.getTag());
    }

    public FluidStack toStack() {
        return new FluidStack((Fluid)this.getFluid().value(), this.getAmount(), this.fluidStack.getTag());
    }
}

