/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.network;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.network.MessageHandler;
import com.klikli_dev.modonomicon.networking.AddBookmarkMessage;
import com.klikli_dev.modonomicon.networking.BookEntryReadMessage;
import com.klikli_dev.modonomicon.networking.ClickCommandLinkMessage;
import com.klikli_dev.modonomicon.networking.ClickReadAllButtonMessage;
import com.klikli_dev.modonomicon.networking.OpenBookOnClientMessage;
import com.klikli_dev.modonomicon.networking.ReloadResourcesDoneMessage;
import com.klikli_dev.modonomicon.networking.ReloadResourcesOnClientMessage;
import com.klikli_dev.modonomicon.networking.RemoveBookmarkMessage;
import com.klikli_dev.modonomicon.networking.RequestAdvancementMessage;
import com.klikli_dev.modonomicon.networking.RequestSyncBookStatesMessage;
import com.klikli_dev.modonomicon.networking.SaveBookStateMessage;
import com.klikli_dev.modonomicon.networking.SaveCategoryStateMessage;
import com.klikli_dev.modonomicon.networking.SaveEntryStateMessage;
import com.klikli_dev.modonomicon.networking.SendAdvancementToClientMessage;
import com.klikli_dev.modonomicon.networking.SendUnlockCodeToClientMessage;
import com.klikli_dev.modonomicon.networking.SendUnlockCodeToServerMessage;
import com.klikli_dev.modonomicon.networking.SyncBookDataMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.networking.SyncBookVisualStatesMessage;
import com.klikli_dev.modonomicon.networking.SyncMultiblockDataMessage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Networking {
    public static final SimpleChannel INSTANCE = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"main")).clientAcceptedVersions((a, b) -> true).serverAcceptedVersions((a, b) -> true).networkProtocolVersion(1).simpleChannel();
    private static int ID = 0;

    public static int nextID() {
        return ID++;
    }

    public static <MSG> BiConsumer<MSG, FriendlyByteBuf> encoder(StreamCodec<RegistryFriendlyByteBuf, MSG> codec) {
        return (msg, buf) -> {
            RegistryFriendlyByteBuf rbuf = (RegistryFriendlyByteBuf)RegistryFriendlyByteBuf.decorator((RegistryAccess)Networking.getRegistryAccess()).apply(buf);
            codec.encode((Object)rbuf, msg);
        };
    }

    public static <MSG> Function<FriendlyByteBuf, MSG> decoder(StreamCodec<RegistryFriendlyByteBuf, MSG> codec) {
        return buf -> {
            RegistryFriendlyByteBuf rbuf = (RegistryFriendlyByteBuf)RegistryFriendlyByteBuf.decorator((RegistryAccess)Networking.getRegistryAccess()).apply(buf);
            return codec.decode((Object)rbuf);
        };
    }

    public static RegistryAccess getRegistryAccess() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return DistHelper.getRegistryAccess();
        }
        return ServerLifecycleHooks.getCurrentServer().registryAccess();
    }

    public static void registerMessages() {
        INSTANCE.messageBuilder(BookEntryReadMessage.class).encoder(Networking.encoder(BookEntryReadMessage.STREAM_CODEC)).decoder(Networking.decoder(BookEntryReadMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(ClickCommandLinkMessage.class).encoder(Networking.encoder(ClickCommandLinkMessage.STREAM_CODEC)).decoder(Networking.decoder(ClickCommandLinkMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(ClickReadAllButtonMessage.class).encoder(Networking.encoder(ClickReadAllButtonMessage.STREAM_CODEC)).decoder(Networking.decoder(ClickReadAllButtonMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SaveBookStateMessage.class).encoder(Networking.encoder(SaveBookStateMessage.STREAM_CODEC)).decoder(Networking.decoder(SaveBookStateMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SaveCategoryStateMessage.class).encoder(Networking.encoder(SaveCategoryStateMessage.STREAM_CODEC)).decoder(Networking.decoder(SaveCategoryStateMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SaveEntryStateMessage.class).encoder(Networking.encoder(SaveEntryStateMessage.STREAM_CODEC)).decoder(Networking.decoder(SaveEntryStateMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SendUnlockCodeToClientMessage.class).encoder(Networking.encoder(SendUnlockCodeToClientMessage.STREAM_CODEC)).decoder(Networking.decoder(SendUnlockCodeToClientMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(OpenBookOnClientMessage.class).encoder(Networking.encoder(OpenBookOnClientMessage.STREAM_CODEC)).decoder(Networking.decoder(OpenBookOnClientMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SendUnlockCodeToServerMessage.class).encoder(Networking.encoder(SendUnlockCodeToServerMessage.STREAM_CODEC)).decoder(Networking.decoder(SendUnlockCodeToServerMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(RequestAdvancementMessage.class).encoder(Networking.encoder(RequestAdvancementMessage.STREAM_CODEC)).decoder(Networking.decoder(RequestAdvancementMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SyncBookDataMessage.class).encoder(Networking.encoder(SyncBookDataMessage.STREAM_CODEC)).decoder(Networking.decoder(SyncBookDataMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SyncBookUnlockStatesMessage.class).encoder(Networking.encoder(SyncBookUnlockStatesMessage.STREAM_CODEC)).decoder(Networking.decoder(SyncBookUnlockStatesMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SyncBookVisualStatesMessage.class).encoder(Networking.encoder(SyncBookVisualStatesMessage.STREAM_CODEC)).decoder(Networking.decoder(SyncBookVisualStatesMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SyncMultiblockDataMessage.class).encoder(Networking.encoder(SyncMultiblockDataMessage.STREAM_CODEC)).decoder(Networking.decoder(SyncMultiblockDataMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(ReloadResourcesOnClientMessage.class).encoder(Networking.encoder(ReloadResourcesOnClientMessage.STREAM_CODEC)).decoder(Networking.decoder(ReloadResourcesOnClientMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(SendAdvancementToClientMessage.class).encoder(Networking.encoder(SendAdvancementToClientMessage.STREAM_CODEC)).decoder(Networking.decoder(SendAdvancementToClientMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(ReloadResourcesDoneMessage.class).encoder(Networking.encoder(ReloadResourcesDoneMessage.STREAM_CODEC)).decoder(Networking.decoder(ReloadResourcesDoneMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(RequestSyncBookStatesMessage.class).encoder(Networking.encoder(RequestSyncBookStatesMessage.STREAM_CODEC)).decoder(Networking.decoder(RequestSyncBookStatesMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(AddBookmarkMessage.class).encoder(Networking.encoder(AddBookmarkMessage.STREAM_CODEC)).decoder(Networking.decoder(AddBookmarkMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
        INSTANCE.messageBuilder(RemoveBookmarkMessage.class).encoder(Networking.encoder(RemoveBookmarkMessage.STREAM_CODEC)).decoder(Networking.decoder(RemoveBookmarkMessage.STREAM_CODEC)).consumerNetworkThread(MessageHandler::handle).add();
    }

    public static <T> void sendToSplit(ServerPlayer player, T message) {
        if (player.connection == null) {
            Modonomicon.LOG.warn("Tried to send message of type {} to player without connection. Id: {}, Name: {}.", new Object[]{player.getStringUUID(), player.getName().getString(), message.getClass().getName()});
            return;
        }
        INSTANCE.send(message, PacketDistributor.PLAYER.with((Object)player));
    }

    public static <T> void sendTo(ServerPlayer player, T message) {
        if (player.connection == null) {
            Modonomicon.LOG.warn("Tried to send message of type {} to player without connection. Id: {}, Name: {}.", new Object[]{player.getStringUUID(), player.getName().getString(), message.getClass().getName()});
            return;
        }
        INSTANCE.send(message, PacketDistributor.PLAYER.with((Object)player));
    }

    public static <T> void sendToServer(T message) {
        INSTANCE.send(message, PacketDistributor.SERVER.noArg());
    }

    public static class DistHelper {
        public static RegistryAccess getRegistryAccess() {
            return Minecraft.getInstance().level.registryAccess();
        }
    }
}

