/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.registry;

import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.registry.DataComponentRegistry;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class CreativeModeTabRegistry {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"modonomicon");
    public static final RegistryObject<CreativeModeTab> MODONOMICON = CREATIVE_MODE_TABS.register("modonomicon", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ItemRegistry.MODONOMICON_PURPLE.get().getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.modonomicon")).build());

    public static void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        ResourceLocation tabName = net.minecraftforge.common.CreativeModeTabRegistry.getName((CreativeModeTab)event.getTab());
        if (tabName == null) {
            return;
        }
        CreativeModeTab modonomiconTab = (CreativeModeTab)MODONOMICON.get();
        ObjectLinkedOpenCustomHashSet searchDupes = new ObjectLinkedOpenCustomHashSet(ItemStackLinkedSet.TYPE_AND_TAG);
        BookDataManager.get().getBooks().values().forEach(b -> {
            if ((event.getTabKey() == CreativeModeTabs.SEARCH || modonomiconTab == event.getTab() || net.minecraftforge.common.CreativeModeTabRegistry.getTab((ResourceLocation)ResourceLocation.parse((String)b.getCreativeTab())) == event.getTab()) && b.generateBookItem()) {
                ItemStack stack = new ItemStack((ItemLike)ItemRegistry.MODONOMICON.get());
                stack.set(DataComponentRegistry.BOOK_ID.get(), (Object)b.getId());
                if (searchDupes.add((Object)stack)) {
                    event.accept(stack, event.getTabKey() == CreativeModeTabs.SEARCH ? CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY : CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        });
    }
}

