/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class GuiGraphicsExt {
    public static int drawString(GuiGraphics guiGraphics, Font font, @Nullable Component component, float x, float y, int color, boolean drawShadow) {
        if (component == null) {
            return 0;
        }
        AtomicInteger i = new AtomicInteger();
        guiGraphics.drawSpecial(bufferSource -> i.set(font.drawInBatch(component, x, y, color, drawShadow, guiGraphics.pose().last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0)));
        return i.get();
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @Nullable String string, float x, float y, int color, boolean drawShadow) {
        if (string == null) {
            return 0;
        }
        AtomicInteger i = new AtomicInteger();
        guiGraphics.drawSpecial(bufferSource -> i.set(font.drawInBatch(string, x, y, color, drawShadow, guiGraphics.pose().last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0)));
        return i.get();
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @Nullable FormattedCharSequence string, float x, float y, int color, boolean drawShadow) {
        if (string == null) {
            return 0;
        }
        AtomicInteger i = new AtomicInteger();
        guiGraphics.drawSpecial(bufferSource -> i.set(font.drawInBatch(string, x, y, color, drawShadow, guiGraphics.pose().last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0)));
        return i.get();
    }

    public static void blitWithBorder(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> function, ResourceLocation texture, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize) {
        GuiGraphicsExt.blitWithBorder(guiGraphics, function, texture, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize);
    }

    public static void blitWithBorder(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> function, ResourceLocation texture, int x, int y, int u, int v, int width, int height, int maxU, int maxV, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        int fillerWidth = maxU - leftBorder - rightBorder;
        int fillerHeight = maxV - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        guiGraphics.blit(function, texture, x, y, (float)u, (float)v, leftBorder, topBorder, 256, 256);
        guiGraphics.blit(function, texture, x + leftBorder + canvasWidth, y, (float)(u + leftBorder + fillerWidth), (float)v, rightBorder, topBorder, 256, 256);
        guiGraphics.blit(function, texture, x, y + topBorder + canvasHeight, (float)u, (float)(v + topBorder + fillerHeight), leftBorder, bottomBorder, 256, 256);
        guiGraphics.blit(function, texture, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, (float)(u + leftBorder + fillerWidth), (float)(v + topBorder + fillerHeight), rightBorder, bottomBorder, 256, 256);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            guiGraphics.blit(function, texture, x + leftBorder + i * fillerWidth, y, (float)(u + leftBorder), (float)v, i == xPasses ? remainderWidth : fillerWidth, topBorder, 256, 256);
            guiGraphics.blit(function, texture, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, (float)(u + leftBorder), (float)(v + topBorder + fillerHeight), i == xPasses ? remainderWidth : fillerWidth, bottomBorder, 256, 256);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                guiGraphics.blit(function, texture, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, (float)(u + leftBorder), (float)(v + topBorder), i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, 256, 256);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            guiGraphics.blit(function, texture, x, y + topBorder + j * fillerHeight, (float)u, (float)(v + topBorder), leftBorder, j == yPasses ? remainderHeight : fillerHeight, 256, 256);
            guiGraphics.blit(function, texture, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, (float)(u + leftBorder + fillerWidth), (float)(v + topBorder), rightBorder, j == yPasses ? remainderHeight : fillerHeight, 256, 256);
        }
    }
}

