// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.api.datagen;

import org.jetbrains.annotations.NotNull;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;

public interface ModonomiconLanguageProvider extends BiConsumer<String, String> {

    default void add(String key, String name){
        this.accept(key, name);
    }

    default void addBlock(Supplier<? extends class_2248> key, String name) {
        this.add(key.get(), name);
    }

    default void add(class_2248 key, String name) {
        this.add(key.method_9539(), name);
    }

    default void addItem(Supplier<? extends class_1792> key, String name) {
        this.add(key.get(), name);
    }

    default void add(class_1792 key, String name) {
        this.add(key.method_7876(), name);
    }

    default void addItemStack(Supplier<class_1799> key, String name) {
        this.add(key.get(), name);
    }

    default void add(class_1799 key, String name) {
        this.add(key.method_7922(), name);
    }

    default void addEffect(Supplier<? extends class_1291> key, String name) {
        this.add(key.get(), name);
    }

    default void add(class_1291 key, String name) {
        this.add(key.method_5567(), name);
    }

    default void addEntityType(Supplier<? extends class_1299<?>> key, String name) {
        this.add(key.get(), name);
    }

    default void add(class_1299<?> key, String name) {
        this.add(key.method_5882(), name);
    }

    /**
     * Return a map containing all translation keys and their values.
     * Alternatively override the second overload to provide the data one-by-one to a bi-consumer.
     */
    default @NotNull Map<String, String> data(){
       return Map.of();
    }

    default void data(BiConsumer<String, String> consumer){
        this.data().forEach(consumer);
    }
}
