/*
 *
 *  * SPDX-FileCopyrightText: 2022 klikli-dev
 *  *
 *  * SPDX-License-Identifier: MIT
 *
 */

package com.klikli_dev.modonomicon.api.datagen.book.condition;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Condition;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_8779;

public class BookAdvancementConditionModel extends BookConditionModel<BookAdvancementConditionModel> {
    private class_2960 advancementId;

    protected BookAdvancementConditionModel() {
        super(Condition.ADVANCEMENT);
    }

    public static BookAdvancementConditionModel create() {
        return new BookAdvancementConditionModel();
    }

    @Override
    public JsonObject toJson(class_2960 conditionParentId, class_7225.class_7874 provider) {
        var json = super.toJson(conditionParentId, provider);
        json.addProperty("advancement_id", this.advancementId.toString());
        return json;
    }

    public class_2960 getAdvancementId() {
        return this.advancementId;
    }

    public BookAdvancementConditionModel withAdvancementId(class_2960 advancementId) {
        this.advancementId = advancementId;
        return this;
    }

    public BookAdvancementConditionModel withAdvancementId(String advancementId) {
        this.advancementId = class_2960.method_60654(advancementId);
        return this;
    }

    public BookAdvancementConditionModel withAdvancement(class_8779 advancement) {
        this.advancementId = advancement.comp_1919();
        return this;
    }

}
