// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT


package com.klikli_dev.modonomicon.book;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

import java.util.function.IntFunction;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public enum PageDisplayMode implements class_3542 {
    DOUBLE_PAGE("double_page"),
    SINGLE_PAGE("single_page");

    public static final class_7292<PageDisplayMode> CODEC = class_3542.method_28140(PageDisplayMode::values);
    private static final IntFunction<PageDisplayMode> BY_ID = class_7995.method_47914(Enum::ordinal, values(), class_7995.class_7996.field_41665);
    public static final class_9139<ByteBuf, PageDisplayMode> STREAM_CODEC = class_9135.method_56375(BY_ID, PageDisplayMode::ordinal);
    private final String name;

    PageDisplayMode(String name) {
        this.name = name;
    }

    public static PageDisplayMode byName(String pName) {
        return CODEC.method_42633(pName);
    }

    public static PageDisplayMode byId(int pId) {
        return BY_ID.apply(pId);
    }

    @Override
    public @NotNull String method_15434() {
        return this.name;
    }
}
