/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.mojang.brigadier.StringReader;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Text;

import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2290;
import net.minecraft.class_2291;
import net.minecraft.class_2291.class_7215;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2568.class_5247;
import net.minecraft.class_2568.class_5249;
import net.minecraft.class_5251;

public class ItemLinkRenderer implements LinkRenderer {

    public static final String PROTOCOL_ITEM = "item://";
    public static final int PROTOCOL_ITEM_LENGTH = PROTOCOL_ITEM.length();

    public static final class_5251 ITEM_LINK_COLOR = class_5251.method_27717(0x029e5a); //light green

    public static boolean isItemLink(String linkText) {
        return linkText.toLowerCase().startsWith(PROTOCOL_ITEM);
    }

    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {

        //[](item://minecraft:diamond)
        //[TestText](item://minecraft:emerald)

        if (link.getDestination().startsWith(PROTOCOL_ITEM)) {

            BookErrorManager.get().setContext("Item Link: {}, \n{}",
                    link.getDestination(),
                    BookErrorManager.get().getContextHelper()
            );

            var currentColor = context.getCurrentStyle().method_10973();


            var itemParser = new class_2291(context.getProvider());
            var itemStack = class_1799.field_8037;
            try {
                var itemId = link.getDestination().substring(PROTOCOL_ITEM_LENGTH);
                var reader = new StringReader(itemId);
                var itemResult = itemParser.method_9789(reader);
                var itemInput = new class_2290(itemResult.comp_628(), itemResult.comp_2439());
                itemStack = itemInput.method_9781(1, false);
            } catch (Exception e) {
                BookErrorManager.get().error("Failed to parse item link.", e);
            }

            //if we have a color we use it, otherwise we use item link default.
            context.setCurrentStyle(context.getCurrentStyle()
                    .method_27703(currentColor == null ? ITEM_LINK_COLOR : currentColor)
                    .method_10949(new class_2568(class_5247.field_24343, new class_5249(itemStack)))
                    .method_10958(new class_2558(class_2558.class_2559.field_11748, link.getDestination()))
            );

            //TODO: show usage infos -> shift to show usage, click to show recipe

            if (link.getLastChild() == null) {
                //if no children, render item name
                link.appendChild(new Text(class_2561.method_43471(itemStack.method_7909().method_7876()).getString()));
            }

            visitChildren.accept(link);


            //links are not style instructions, so we reset to our previous color.
            context.setCurrentStyle(context.getCurrentStyle()
                    .method_27703(currentColor)
                    .method_10949(null)
            );

            BookErrorManager.get().setContext(null);

            return true;
        }
        return false;
    }
}
