/*
 * SPDX-FileCopyrightText: 2022 Authors of Patchouli
 *
 * SPDX-License-Identifier: MIT
 */
package com.klikli_dev.modonomicon.multiblock;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;


public class SimulateResultImpl implements Multiblock.SimulateResult {
    private final class_2338 worldPosition;
    private final StateMatcher stateMatcher;
    @Nullable
    private final Character character;

    public SimulateResultImpl(class_2338 worldPosition, StateMatcher stateMatcher, @Nullable Character character) {
        this.worldPosition = worldPosition;
        this.stateMatcher = stateMatcher;
        this.character = character;
    }

    @Override
    public class_2338 getWorldPosition() {
        return this.worldPosition;
    }

    @Override
    public StateMatcher getStateMatcher() {
        return this.stateMatcher;
    }

    @Nullable
    @Override
    public Character getCharacter() {
        return this.character;
    }

    @Override
    public boolean test(class_1937 world, class_2470 rotation) {
        var pos = this.getWorldPosition();
        class_2680 state = world.method_8320(pos).method_26186(AbstractMultiblock.fixHorizontal(rotation));
        return this.getStateMatcher().getStatePredicate().test(world, pos, state);
    }
}
