/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

/**
 * Matches a BlockState, respecting all BlockState properties.
 */
public class BlockStateMatcher implements StateMatcher {
    public static final class_2960 TYPE = Modonomicon.loc("blockstate");

    private final class_2680 displayState;
    private final class_2680 blockState;
    private final TriPredicate<class_1922, class_2338, class_2680> predicate;

    protected BlockStateMatcher(class_2680 displayState, class_2680 blockState) {
        this.displayState = displayState;
        this.blockState = blockState;
        this.predicate = (blockGetter, blockPos, state) -> state == blockState;
    }

    public static BlockStateMatcher from(class_2680 blockState) {
        return new BlockStateMatcher(null, blockState);
    }

    public static BlockStateMatcher from(class_2680 displayState, class_2680 blockState) {
        return new BlockStateMatcher(displayState, blockState);
    }

    public static BlockStateMatcher fromJson(JsonObject json, class_7225.class_7874 provider) {
        class_2680 displayState = null;
        if (json.has("display")) {
            try {
                displayState = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(class_3518.method_15265(json, "display")), false).comp_622();
            } catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for BlockStateMatcher.", e);
            }
        }

        try {
            var blockState = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(class_3518.method_15265(json, "block")), false).comp_622();
            return new BlockStateMatcher(displayState, blockState);
        } catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"block\" for BlockStateMatcher.", e);
        }

    }

    public static BlockStateMatcher fromNetwork(class_2540 buffer) {
        try {
            class_2680 displayState = null;
            if (buffer.readBoolean())
                displayState = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(buffer.method_19772()), false).comp_622();

            var blockState = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(buffer.method_19772()), false).comp_622();

            return new BlockStateMatcher(displayState, blockState);
        } catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockStateMatcher from network.", e);
        }
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }

    @Override
    public class_2680 getDisplayedState(long ticks) {
        return this.displayState == null ? this.blockState : this.displayState;
    }

    @Override
    public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.method_52964(this.displayState != null);
        if (this.displayState != null)
            buffer.method_10814(class_2259.method_9685(this.displayState));
        buffer.method_10814(class_2259.method_9685(this.blockState));
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.blockState, this.displayState);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        var that = (BlockStateMatcher) o;
        return this.blockState.equals(that.blockState) && this.displayState.equals(that.displayState);
    }
}
