/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2259.class_7211;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

/**
 * Matches a BlockState, respecting only the provided BlockState properties.
 */
public class BlockStatePropertyMatcher implements StateMatcher {
    public static final class_2960 TYPE = Modonomicon.loc("blockstateproperty");

    private final class_2680 displayState;
    private final class_2248 block;

    private final Supplier<Map<String, String>> props;
    private final TriPredicate<class_1922, class_2338, class_2680> predicate;

    protected BlockStatePropertyMatcher(class_2680 displayState, class_2248 block, Supplier<Map<String, String>> props) {
        this.displayState = displayState;
        this.block = block;
        this.props = props;
        this.predicate = (blockGetter, blockPos, blockState) -> blockState.method_26204() == block && TagMatcher.checkProps(blockState, this.props);
    }

    public static BlockStatePropertyMatcher fromJson(JsonObject json, class_7225.class_7874 provider) {
        class_2680 displayState = null;
        if (json.has("display")) {
            try {
                displayState = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(class_3518.method_15265(json, "display")), false).comp_622();
            } catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for BlockStatePropertyMatcher.", e);
            }
        }

        try {
            var result = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(class_3518.method_15265(json, "block")), false);

            var props = convertProps(result.comp_623());
            return new BlockStatePropertyMatcher(displayState, result.comp_622().method_26204(), Suppliers.memoize(() -> props));
        } catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"block\" for BlockStatePropertyMatcher.", e);
        }

    }

    public static BlockStatePropertyMatcher fromNetwork(class_2540 buffer) {
        try {
            class_2680 displayState = null;
            if (buffer.readBoolean())
                displayState = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(buffer.method_19772()), false).comp_622();

            var block = class_7923.field_41175.method_10223(buffer.method_10810());
            var props = buffer.method_34067((b) -> b.method_19772(), (b) -> b.method_19772());


            return new BlockStatePropertyMatcher(displayState, block, Suppliers.memoize(() -> props));
        } catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockStatePropertyMatcher from network.", e);
        }
    }

    private static Map<String, String> convertProps(Map<class_2769<?>, Comparable<?>> props) {
        Map<String, String> newProps = new Object2ObjectOpenHashMap<>();
        for (var entry : props.entrySet()) {

            appendProperty(newProps, entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    private static <T extends Comparable<T>> void appendProperty(Map<String, String> properties, class_2769<T> pProperty, Comparable<?> pValue) {
        properties.put(pProperty.method_11899(), pProperty.method_11901((T) pValue));
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }

    @Override
    public class_2680 getDisplayedState(long ticks) {
        return this.displayState == null ? this.block.method_9564() : this.displayState;
    }

    @Override
    public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.method_52964(this.displayState != null);
        if (this.displayState != null)
            buffer.method_10814(class_2259.method_9685(this.displayState));
        buffer.method_10812(class_7923.field_41175.method_10221(this.block));
        buffer.method_34063(this.props.get(), (b, v) -> b.method_10814(v), (b, v) -> b.method_10814(v));
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.block, this.displayState, this.props);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        var that = (BlockStatePropertyMatcher) o;
        return this.block.equals(that.block) && this.props.equals(that.props) && this.displayState.equals(that.displayState);
    }
}
