/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import Z;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class ClickReadAllButtonMessage implements Message {

    public static final class_9154<ClickReadAllButtonMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "click_read_all_button"));

    public static final class_9139<class_9129, ClickReadAllButtonMessage> STREAM_CODEC = class_9139.method_56435(
            class_2960.field_48267,
            (m) -> m.bookId,
            class_9135.field_48547,
            (m) -> m.readAll,
            ClickReadAllButtonMessage::new
    );

    public class_2960 bookId;
    public boolean readAll; //true to not only read unlocked but even the locked ones

    public ClickReadAllButtonMessage(class_2960 bookId, boolean readAll) {
        this.bookId = bookId;
        this.readAll = readAll;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var book = BookDataManager.get().getBook(this.bookId);
        if (book != null) {
            //unlock pages, then update the unlock capability, finally sync.
            var anyRead = false;
            for (var entry : book.getEntries().values()) {
                if ((this.readAll || BookUnlockStateManager.get().isUnlockedFor(player, entry)) && BookUnlockStateManager.get().readFor(player, entry)) {
                    anyRead = true;
                }
            }

            if (anyRead) {
                BookUnlockStateManager.get().updateAndSyncFor(player);
            }
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
