/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Command;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class SendUnlockCodeToServerMessage implements Message {

    public static final class_9154<SendUnlockCodeToServerMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "send_unlock_code_to_server"));

    public static final class_9139<class_9129, SendUnlockCodeToServerMessage> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48554,
            (m) -> m.unlockCode,
            SendUnlockCodeToServerMessage::new
    );

    public String unlockCode;

    public SendUnlockCodeToServerMessage(String unlockCode) {
        this.unlockCode = unlockCode;
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var book = BookUnlockStateManager.get().applyUnlockCodeFor(player, this.unlockCode);
        if (book != null) {
            player.method_43496(class_2561.method_43469(Command.SUCCESS_LOAD_PROGRESS, class_2561.method_43471(book.getName())));
        } else {
            player.method_43496(class_2561.method_43471(Command.ERROR_LOAD_PROGRESS).method_27692(class_124.field_1061));
        }

    }
}
