/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.registry;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.command.LoadUnlocksCommand;
import com.klikli_dev.modonomicon.command.ReloadBooksCommand;
import com.klikli_dev.modonomicon.command.ResetBookUnlocksCommand;
import com.klikli_dev.modonomicon.command.SaveUnlocksCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class CommandRegistry {

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode<class_2168> modonomiconCommand = dispatcher.register(
                class_2170.method_9247(Modonomicon.MOD_ID)
                        .then(ResetBookUnlocksCommand.register(dispatcher))
                        .then(SaveUnlocksCommand.register(dispatcher))
                        .then(ReloadBooksCommand.register(dispatcher))
        );

        dispatcher.register(class_2170.method_9247(Modonomicon.MOD_ID).redirect(modonomiconCommand));
    }

    public static void registerClientCommands(CommandDispatcher<class_2168> dispatcher) {

        LiteralCommandNode<class_2168> modonomiconCommand = dispatcher.register(
                class_2170.method_9247(Modonomicon.MOD_ID)
                        .then(LoadUnlocksCommand.register(dispatcher))
        );

        dispatcher.register(class_2170.method_9247(Modonomicon.MOD_ID).redirect(modonomiconCommand));
    }

}
