/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.api.datagen.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Page;
import com.klikli_dev.modonomicon.api.datagen.book.BookTextHolderModel;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

public class BookMultiblockPageModel extends BookPageModel<BookMultiblockPageModel> {
    protected BookTextHolderModel multiblockName = new BookTextHolderModel("");
    protected BookTextHolderModel text = new BookTextHolderModel("");
    protected class_2960 multiblockId = null;
    protected boolean showVisualizeButton = true;

    protected BookMultiblockPageModel() {
        super(Page.MULTIBLOCK);
    }

    public static BookMultiblockPageModel create() {
        return new BookMultiblockPageModel();
    }

    public BookTextHolderModel getMultiblockName() {
        return this.multiblockName;
    }

    public class_2960 getMultiblockId() {
        return this.multiblockId;
    }

    public BookTextHolderModel getText() {
        return this.text;
    }

    public boolean showVisualizeButton() {
        return this.showVisualizeButton;
    }

    @Override
    public JsonObject toJson(class_2960 entryId, class_7225.class_7874 provider) {
        var json = super.toJson(entryId, provider);
        json.add("multiblock_name", this.multiblockName.toJson(provider));
        json.add("text", this.text.toJson(provider));
        json.addProperty("show_visualize_button", this.showVisualizeButton);

        //if we are in the same namespace, which we basically always should be, omit namespace
        if (this.multiblockId.method_12836().equals(entryId.method_12836()))
            json.addProperty("multiblock_id", this.multiblockId.method_12832());
        else
            json.addProperty("multiblock_id", this.multiblockId.toString());

        return json;
    }

    public BookMultiblockPageModel withMultiblockName(String title) {
        this.multiblockName = new BookTextHolderModel(title);
        return this;
    }

    public BookMultiblockPageModel withMultiblockName(class_2561 title) {
        this.multiblockName = new BookTextHolderModel(title);
        return this;
    }

    public BookMultiblockPageModel withMultiblockId(class_2960 multiblockId) {
        this.multiblockId = multiblockId;
        return this;
    }

    public BookMultiblockPageModel withText(String text) {
        this.text = new BookTextHolderModel(text);
        return this;
    }

    public BookMultiblockPageModel withText(class_2561 text) {
        this.text = new BookTextHolderModel(text);
        return this;
    }

    public BookMultiblockPageModel withVisualizeButton(boolean showVisualizeButton) {
        this.showVisualizeButton = showVisualizeButton;
        return this;
    }
}
