// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.api.events;

import com.klikli_dev.modonomicon.client.gui.book.entry.EntryDisplayState;
import net.minecraft.class_11909;
import net.minecraft.class_2960;

/**
 * An event that is fired on the client-side when an entry is clicked in the book.
 * If the event is cancelled by a listener, the entry will not be displayed.
 */
public class EntryClickedEvent extends ModonomiconEvent {
    protected class_2960 bookId;
    protected class_2960 entryId;

    protected class_11909 mouseButtonEvent;

    protected EntryDisplayState displayState;

    public EntryClickedEvent(class_2960 bookId, class_2960 entryId, class_11909 mouseButtonEvent, EntryDisplayState displayState) {
        super(true);

        this.bookId = bookId;
        this.entryId = entryId;
        this.mouseButtonEvent = mouseButtonEvent;
        this.displayState = displayState;
    }

    public class_2960 getBookId() {
        return this.bookId;
    }

    public class_2960 getEntryId() {
        return this.entryId;
    }

    /**
     * For categories in Index mode this has the X coordinate of the button that was clicked, instead of the mouse cursor that clicked it.
     * For categories in Index mode this has the Y coordinate of the button that was clicked, instead of the mouse cursor that clicked it.
     * For categories in Index mode this always has GLFW_MOUSE_BUTTON_1 (= 0 = left mouse button).
     */
    public class_11909 getMouseButtonEvent() {
        return this.mouseButtonEvent;
    }

    public EntryDisplayState getDisplayState() {
        return this.displayState;
    }
}
