/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class BookEntryParent {
    protected class_2960 entryId;
    protected boolean drawArrow = true;
    protected boolean lineEnabled = true;
    protected boolean lineReversed = false;

    public BookEntryParent(class_2960 entry) {
        this.entryId = entry;
    }

    /**
     * Creates a new BookEntryParent from the given json object.
     * @param ownerEntryId the entry id of the entry that contains this parent information. This is the CHILD not the parent.
     * @param json the json object to read from
     */
    public static BookEntryParent fromJson(class_2960 ownerEntryId, JsonObject json) {
        var parentEntryPath = class_3518.method_15265(json, "entry");
        //entries can be without a namespace, in which case we use the owner entry namespace.
        var parentEntryId = parentEntryPath.contains(":") ?
                class_2960.method_60654(parentEntryPath) :
                class_2960.method_60655(ownerEntryId.method_12836(), parentEntryPath);

        var parent = new BookEntryParent(parentEntryId);
        parent.drawArrow = class_3518.method_15258(json, "draw_arrow", parent.drawArrow);
        parent.lineEnabled = class_3518.method_15258(json, "line_enabled", parent.lineEnabled);
        parent.lineReversed = class_3518.method_15258(json, "line_reversed", parent.lineReversed);
        return parent;
    }

    public static BookEntryParent fromNetwork(class_2540 buffer) {
        var entry = buffer.method_10810();
        var parent = new BookEntryParent(entry);
        parent.drawArrow = buffer.readBoolean();
        parent.lineEnabled = buffer.readBoolean();
        parent.lineReversed = buffer.readBoolean();
        return parent;
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10812(this.entryId);
        buffer.method_52964(this.drawArrow);
        buffer.method_52964(this.lineEnabled);
        buffer.method_52964(this.lineReversed);
    }

    public BookEntry getEntry() {
        throw new UnsupportedOperationException("BookEntryParent is not resolved yet.");
    }

    public class_2960 getEntryId() {
        return this.entryId;
    }

    public boolean drawArrow() {
        return this.drawArrow;
    }

    public boolean isLineEnabled() {
        return this.lineEnabled;
    }

    public boolean isLineReversed() {
        return this.lineReversed;
    }
}
