/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Page;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import net.minecraft.class_2960;
import net.minecraft.class_3862;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class BookSmokingRecipePage extends BookProcessingRecipePage<class_3862> {

    public BookSmokingRecipePage(JsonDataHolder common) {
        super(common);
    }

    public BookSmokingRecipePage(NetworkDataHolder common) {
        super(common);
    }

    public static BookSmokingRecipePage fromJson(class_2960 entryId, JsonObject json, class_7225.class_7874 provider) {
        var common = BookRecipePage.commonFromJson(entryId, json, provider);
        return new BookSmokingRecipePage(common);
    }

    public static BookSmokingRecipePage fromNetwork(class_9129 buffer) {
        var common = BookRecipePage.commonFromNetwork(buffer);
        return new BookSmokingRecipePage(common);
    }

    @Override
    public class_2960 getType() {
        return Page.SMOKING_RECIPE;
    }
}
