/*
 * SPDX-FileCopyrightText: 2024 DaFuqs
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.button.ArrowButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ExitButton;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

public abstract class BookPaginatedScreen extends class_437 implements BookScreenWithButtons {

    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;

    public static final int BOOK_BACKGROUND_WIDTH = 272;
    public static final int BOOK_BACKGROUND_HEIGHT = 178;

    protected int bookLeft;
    protected int bookTop;

    protected boolean addExitButton;

    public BookPaginatedScreen(class_2561 component) {
        this(component, true);
    }

    public BookPaginatedScreen(class_2561 component, boolean addExitButton) {
        super(component);

        this.addExitButton = addExitButton;
    }

    @Override
    protected void method_25426() {
        this.bookLeft = (this.field_22789 - BOOK_BACKGROUND_WIDTH) / 2;
        this.bookTop = (this.field_22790 - BOOK_BACKGROUND_HEIGHT) / 2;

        this.initNavigationButtons();
    }

    protected void initNavigationButtons() {
        this.method_37063(new ArrowButton(this, this.bookLeft - 4, this.bookTop + FULL_HEIGHT - 6, true, () -> this.canSeeArrowButton(true), this::handleArrowButton));
        this.method_37063(new ArrowButton(this, this.bookLeft + FULL_WIDTH - 14, this.bookTop + FULL_HEIGHT - 6, false, () -> this.canSeeArrowButton(false), this::handleArrowButton));
        if (this.addExitButton) {
            this.method_37063(new ExitButton(this, this.bookLeft + FULL_WIDTH - 10, this.bookTop - 2, this::handleExitButton));
        }
    }

    public void handleExitButton(class_4185 button) {
        this.method_25419();
    }

    public abstract boolean canSeeArrowButton(boolean left);

    /**
     * Needs to use Button instead of ArrowButton to conform to Button.OnPress otherwise we can't use it as method
     * reference, which we need - lambda can't use this in super constructor call.
     */
    public void handleArrowButton(class_4185 button) {
        this.flipPage(((ArrowButton) button).left, true);
    }

    protected abstract void flipPage(boolean left, boolean playSound);

    protected boolean isClickOutsideEntry(double pMouseX, double pMouseY) {
        return pMouseX < this.bookLeft - BookEntryScreen.CLICK_SAFETY_MARGIN
                || pMouseX > this.bookLeft + BookEntryScreen.FULL_WIDTH + BookEntryScreen.CLICK_SAFETY_MARGIN
                || pMouseY < this.bookTop - BookEntryScreen.CLICK_SAFETY_MARGIN
                || pMouseY > this.bookTop + BookEntryScreen.FULL_HEIGHT + BookEntryScreen.CLICK_SAFETY_MARGIN;
    }

    @Override
    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == GLFW.GLFW_KEY_BACKSPACE) {
            this.back();
            return true;
        }

        return super.method_25404(event);
    }

    public boolean canSeeBackButton() {
        return BookGuiManager.get().getHistorySize(this.getBook().getId()) > 0;
    }

    public void handleBackButton(class_4185 button) {
        this.back();
    }

    public void back() {
        if (BookGuiManager.get().getHistorySize(this.getBook().getId()) > 0) {
            var lastPage = BookGuiManager.get().popHistory(this.getBook().getId());
            BookGuiManager.get().openEntry(lastPage.bookId(), lastPage.categoryId(), lastPage.entryId(), lastPage.page());
        } else {
            this.method_25419();
        }
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (this.isClickOutsideEntry(event.comp_4798(), event.comp_4799())) {
            this.method_25419();
            return true; //need to return, otherwise a right click outside the entry causes a double-close (the whole book, due to calling .back() below)
        }

        if (event.method_74245() == GLFW.GLFW_MOUSE_BUTTON_RIGHT) {
            this.back();
            return true;
        }


        return super.method_25402(event, isDoubleClick);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0) {
            this.flipPage(false, true);
        } else if (scrollY > 0) {
            this.flipPage(true, true);
        }

        return true;
    }
}
