// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.client.gui.book.entry;

import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.ArrowButton;
import com.klikli_dev.modonomicon.client.gui.book.button.BackButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ExitButton;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class BookEntrySinglePageScreen extends BookEntryScreen {

    public static final int SINGLE_PAGE_BOOK_BACKGROUND_WIDTH = 145;
    public static final int SINGLE_PAGE_BOOK_BACKGROUND_HEIGHT = 178;
    protected final class_2960 singlePageTexture;
    private BookPage page;
    private BookPageRenderer<?> pageRenderer;

    public BookEntrySinglePageScreen(BookParentScreen parentScreen, BookContentEntry entry) {
        super(parentScreen, entry);

        this.singlePageTexture = entry.getBook().getSinglePageTexture();
    }

    public static void renderSinglePageBookBackground(class_332 guiGraphics, class_2960 bookContentTexture) {
        int x = 0; // (this.width - BOOK_BACKGROUND_WIDTH) / 2;
        int y = 0; // (this.height - BOOK_BACKGROUND_HEIGHT) / 2;

        guiGraphics.method_25290(class_10799.field_56883, bookContentTexture, x, y, 0, 0, 145, 178, 256, 256);
    }

    @Override
    protected void initNavigationButtons() {
        this.bookLeft = (this.field_22789 - SINGLE_PAGE_BOOK_BACKGROUND_WIDTH) / 2;
        this.bookTop = (this.field_22790 - SINGLE_PAGE_BOOK_BACKGROUND_HEIGHT) / 2;

        //paginated screen assumes a double page layout, so we have to override the init here and place our buttons as we like.

        //TODO: this can probably be optimized to instead hand over the height/width stuff to the parent screen
        //      maybe with configurable offsets
        this.method_37063(new ArrowButton(this, this.bookLeft - 4, this.bookTop + SINGLE_PAGE_BOOK_BACKGROUND_HEIGHT - 6, true, () -> this.canSeeArrowButton(true), this::handleArrowButton));
        this.method_37063(new ArrowButton(this, this.bookLeft + SINGLE_PAGE_BOOK_BACKGROUND_WIDTH - 14, this.bookTop + SINGLE_PAGE_BOOK_BACKGROUND_HEIGHT - 6, false, () -> this.canSeeArrowButton(false), this::handleArrowButton));
        if (this.addExitButton) {
            this.method_37063(new ExitButton(this, this.bookLeft + SINGLE_PAGE_BOOK_BACKGROUND_WIDTH - 10, this.bookTop - 2, this::handleExitButton));
        }
        this.method_37063(new BackButton(this, this.field_22789 / 2 - BackButton.WIDTH / 2, this.bookTop + SINGLE_PAGE_BOOK_BACKGROUND_HEIGHT - BackButton.HEIGHT / 2));

//        this.updateBookmarksButton(); //no bookmarks on leaflets!
    }

    @Override
    protected int getOpenPagesIndexForPage(int pageIndex) {
        return pageIndex; //for single page screens the index is equivalent to the page number
    }

    @Override
    protected int getPageForOpenPagesIndex(int openPagesIndex) {
        return openPagesIndex;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : (this.openPagesIndex + 1) < this.unlockedPages.size();
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            if (left) {
                this.openPagesIndex -= 1;
            } else {
                this.openPagesIndex += 1;
            }

            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.getBook());
            }
        }
    }

    @Override
    @Nullable
    public class_2583 getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        return this.getClickedComponentStyleAtForPage(this.pageRenderer, pMouseX, pMouseY);
    }

    @Override
    public boolean mouseClickedPage(class_11909 event, boolean isDoubleClick) {
        return this.clickPage(this.pageRenderer, event, isDoubleClick);
    }

    protected void beginDisplayPages() {
        //allow pages to clean up
        if (this.pageRenderer != null) {
            this.pageRenderer.onEndDisplayPage(this);
        }

        //get new pages
        int pageIndex = this.openPagesIndex;

        this.page = pageIndex < this.unlockedPages.size() ? this.unlockedPages.get(pageIndex) : null;

        //allow pages to prepare for being displayed
        if (this.page != null) {
            this.pageRenderer = PageRendererRegistry.getPageRenderer(this.page.getType()).create(this.page);
            this.pageRenderer.onBeginDisplayPage(this, SINGLE_PAGE_X, TOP_PADDING);
        } else {
            this.pageRenderer = null;
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.resetTooltip();

        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate(this.bookLeft, this.bookTop);
        renderSinglePageBookBackground(guiGraphics, this.singlePageTexture);
        guiGraphics.method_51448().popMatrix();
        guiGraphics.method_71048();

        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate(this.bookLeft, this.bookTop);
        this.renderPage(guiGraphics, this.pageRenderer, pMouseX, pMouseY, pPartialTick);
        guiGraphics.method_51448().popMatrix();
        guiGraphics.method_71048();

        //do not translate super (= widget rendering) -> otherwise our buttons are messed up
        //manually call the renderables like super does -> otherwise super renders the background again on top of our stuff
        for (var renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }

        //do not translate tooltip, would mess up location
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }
}
