// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.integration.jei.ModonomiconJeiIntegration;
import com.mojang.brigadier.StringReader;
import net.minecraft.class_1799;
import net.minecraft.class_2290;
import net.minecraft.class_2291;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class ItemLinkHandler extends LinkHandler {

    private final class_2291 itemParser;

    public ItemLinkHandler(BookEntryScreen screen) {
        super(screen);
        this.itemParser = new class_2291(class_310.method_1551().field_1687.method_30349());
    }

    @Override
    public ClickResult handleClick(@NotNull class_2583 pStyle) {
        var event = pStyle.method_10970();
        if (event == null)
            return ClickResult.UNHANDLED;

        //Item links use OPEN_FILE action as it allows us to hand over a string.
        //the isItemLink below will check for a protocol prefix
        if (event.method_10845() != class_2558.class_2559.field_11746 || !(event instanceof class_2558.class_10607 openFile))
            return ClickResult.UNHANDLED;

        if (!ItemLinkRenderer.isItemLink(openFile.comp_3504()))
            return ClickResult.UNHANDLED;

        if (!ModonomiconJeiIntegration.get().isLoaded())
            return ClickResult.FAILURE;


        var itemStack = class_1799.field_8037;
        try {
            var itemId = openFile.comp_3504().substring(ItemLinkRenderer.PROTOCOL_ITEM_LENGTH);
            var reader = new StringReader(itemId);
            var itemResult = this.itemParser.method_9789(reader);
            var itemInput = new class_2290(itemResult.comp_628(), itemResult.comp_2439());
            itemStack = itemInput.method_9781(1, false);
        } catch (Exception e) {
            Modonomicon.LOG.error("Failed to parse item link: {}", openFile.comp_3504(), e);
            return ClickResult.FAILURE;
        }

        final var finalItemStack = itemStack;
        BookGuiManager.get().keepMousePosition(() -> {
            BookGuiManager.get().closeScreenStack(this.screen()); //will cause the book to close entirely, and save the open page

            if (class_310.method_1551().method_74187()) {
                ModonomiconJeiIntegration.get().showUses(finalItemStack);
            } else {
                ModonomiconJeiIntegration.get().showRecipe(finalItemStack);
            }
        });


        //TODO: Consider adding logic to restore content screen after JEI gui close
        //      currently only the overview screen is restored (because JEI does not use Forges Gui Stack, only vanilla screen, thus only saves one parent screen)
        //      we could fix that by listening to the Closing event from forge, and in that set the closing time
        //      -> then on init of overview screen, if closing time is < delta, push last content screen from gui manager

        return ClickResult.SUCCESS;
    }
}
