/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 * SPDX-FileCopyrightText: 2021 Authors of Patchouli
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.index;

import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.node.BookParentNodeScreen;
import net.minecraft.class_11909;
import net.minecraft.class_332;

/**
 * A special version of the BookCategoryIndexScreen that is intended to be rendered on top of a parent node screen (instead of a parent index screen)
 */
public class BookCategoryIndexOnNodeScreen extends BookCategoryIndexScreen {

    public BookCategoryIndexOnNodeScreen(BookParentScreen parentScreen, BookCategory category) {
        super(parentScreen, category, false);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);

        if (BookGuiManager.get().openBookParentScreen instanceof BookParentNodeScreen parentScreen) {
            parentScreen.renderMouseXOverride = pMouseX;
            parentScreen.renderMouseYOverride = pMouseY;
        }
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        //we prevent the default background rendering because we still need to see the underlying parent node screen
    }

    @Override
    public void method_25419() {
        //on close might come from paginated screen, and in our parent would ask the gui manager to close us
        //but this special index screen can only be closed together with the parent screen -> on esc.
        //so we simply don't do anything here.
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        //if we click outside, we don't close like the parent would, instead we let the click unhandled so the parent can handle it
        if (this.isClickOutsideEntry(event.comp_4798(), event.comp_4799())) {
            if (BookGuiManager.get().openBookParentScreen instanceof BookParentNodeScreen parentScreen) {
                return parentScreen.method_25402(event, isDoubleClick);
            }

            return false;
        }

        //with the "outside closing" prevented we can let our parents do the rest
        return super.method_25402(event, isDoubleClick);
    }
}
