/*
 * SPDX-FileCopyrightText: 2025 XFactHD
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.render;

import org.jetbrains.annotations.NotNull;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_4588;
import net.minecraft.class_9848;

public final class GhostVertexConsumer extends VertexConsumerWrapper {
    private static final Map<class_4588, class_4588> remappedVertexConsumers = new IdentityHashMap<>();

    private final int alpha;
    private final int white;

    public GhostVertexConsumer(class_4588 wrapped, int alpha) {
        super(wrapped);
        this.alpha = alpha;
        this.white = class_9848.method_61330(alpha, 0xFFFFFF);
    }

    public static class_4588 remap(class_4588 in) {
        return remappedVertexConsumers.computeIfAbsent(in, (type) -> {
            return new GhostVertexConsumer(in, (int) (0.4f * 255));
        });
    }

    @Override
    public void method_23919(float x, float y, float z, int color, float u, float v, int overlay, int light, float nx, float ny, float nz) {
        this.parent.method_23919(x, y, z, class_9848.method_61322(this.white, color), u, v, overlay, light, nx, ny, nz);
    }

    @Override
    public @NotNull class_4588 method_1336(int red, int green, int blue, int alpha) {
        return this.parent.method_1336(red, green, blue, (alpha * this.alpha) / 0xFF);
    }
}