package com.klikli_dev.modonomicon.client.render.pip;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.state.pip.GuiMultiblockRenderState;
import net.minecraft.class_11239;
import net.minecraft.class_12075;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class GuiMultiblockRenderer extends class_11239<GuiMultiblockRenderState> {

    public GuiMultiblockRenderer(class_4597.class_4598 bufferSource) {
        super(bufferSource);
    }

    @Override
    public Class<GuiMultiblockRenderState> method_70903() {
        return GuiMultiblockRenderState.class;
    }

    @Override
    protected void renderToTexture(GuiMultiblockRenderState state, class_4587 poseStack) {
        var mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) return;

        // Provide level to multiblock for client-side state
        state.multiblock().setLevel(level);

        var size = state.size();
        int sizeX = size.method_10263();
        int sizeY = size.method_10264();
        int sizeZ = size.method_10260();

        // Center the multiblock
        poseStack.method_46416((float) sizeX / 2, (float) sizeY / 2, 0);

        // Initial eye position for lighting calculations - positioned behind the scene
        Vector4f eye = new Vector4f(0, 0, -100, 1);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();

        // Flip the structure 180° around Z-axis to correct the upside-down rendering
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180F));
        rotMat.rotate(class_7833.field_40718.rotationDegrees(-180));

        // Apply isometric-style tilt: rotate around X-axis
        // Positive rotation tilts the structure for proper isometric view
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-30F));
        rotMat.rotate(class_7833.field_40714.rotationDegrees(30));

        // Calculate offsets for centering the rotation pivot point
        float offX = (float) -sizeX / 2;
        float offZ = (float) -sizeZ / 2 + 1;

        // Apply animated Y-axis rotation (spinning effect)
        // Translate to center, apply rotations, then translate back
        float time = state.rotationTime();
        poseStack.method_46416(-offX, 0, -offZ);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(time));
        rotMat.rotate(class_7833.field_40716.rotationDegrees(-time));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(45));
        rotMat.rotate(class_7833.field_40716.rotationDegrees(-45));
        poseStack.method_46416(offX, 0, offZ);

        // Transform the eye position by the inverse rotation matrix for correct lighting
        rotMat.transform(eye);
        eye.div(eye.w);
        class_243 eye3 = new class_243(eye.x(), eye.y(), eye.z());

        class_4597.class_4598 buffers = this.field_59933;

        class_2338 checkPos = null;
        if (mc.field_1765 instanceof class_3965 blockRes) {
            checkPos = blockRes.method_17777().method_10093(blockRes.method_17780());
        }

        // Apply slight Z offset to prevent Z-fighting between blocks
        poseStack.method_22903();
        poseStack.method_46416(0, 0, -1);

        for (Multiblock.SimulateResult r : state.simulateResults()) {
            float alpha = 0.3F;
            if (r.getWorldPosition().equals(checkPos)) {
                alpha = 0.6F + (float) (Math.sin(ClientTicks.total * 0.3F) + 1F) * 0.1F;
            }

            class_2680 displayedBlockState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).method_26186(state.facingRotation());

            // Render block (via platform service)
            renderBlock(buffers, level, state.multiblock(), displayedBlockState, r.getWorldPosition(), alpha, poseStack, state.randomSource());

            if (displayedBlockState.method_26204() instanceof class_2343 eb) {
                var cache = state.blockEntityCache();
                var errored = state.erroredBlockEntities();

                var be = cache.compute(r.getWorldPosition().method_10062(), (p, cachedBe) -> {
                    if (cachedBe != null && !cachedBe.method_11017().method_20526(displayedBlockState)) {
                        return eb.method_10123(p, displayedBlockState);
                    }
                    return cachedBe != null ? cachedBe : eb.method_10123(p, displayedBlockState);
                });

                if (be != null && !errored.contains(be)) {
                    be.method_31662(mc.field_1687);
                    //noinspection deprecation
                    be.method_31664(displayedBlockState);

                    poseStack.method_22903();
                    var bePos = r.getWorldPosition();
                    poseStack.method_46416(bePos.method_10263(), bePos.method_10264(), bePos.method_10260());

                    try {
                        var dispatcher = class_310.method_1551().method_31975();
                        var renderer = dispatcher.method_3550(be);
                        if (renderer != null) {
                            var renderState = renderer.method_74335();
                            //Note: we cannot use Minecraft.getInstance().getBlockEntityRenderDispatcher().tryExtractRenderState because that takes the camera eye position of the in-world camera
                            renderer.method_74331(be, renderState, ClientTicks.partialTicks, eye3, null);
                            renderState.field_62676 = class_765.field_32767;
                            var featureDispatcher = class_310.method_1551().field_1773.method_72911();
                            var cameraRenderState = new class_12075();
                            dispatcher.method_3555(renderState, poseStack, featureDispatcher.method_73003(), cameraRenderState);
                            featureDispatcher.method_73002();
                        }
                    } catch (Exception e) {
                        errored.add(be);
                        Modonomicon.LOG.error("Error rendering block entity", e);
                    }
                    poseStack.method_22909();
                }
            }
        }
        poseStack.method_22909();
    }

    private void renderBlock(class_4597.class_4598 buffers, class_638 level, Multiblock multiblock, class_2680 state, class_2338 pos, float alpha, class_4587 ps, net.minecraft.class_5819 randomSource) {
        if (pos != null) {
            ps.method_22903();
            ps.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
            // Delegate to platform abstraction for block rendering
            com.klikli_dev.modonomicon.platform.ClientServices.MULTIBLOCK.renderBlock(state, pos, multiblock, ps, buffers, randomSource);
            ps.method_22909();
        }
    }

    @Override
    protected float method_70907(int height, int guiScale) {
        return height / 2.0F;
    }

    @Override
    protected String method_70906() {
        return "multiblock";
    }
}
