/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.gui;

import com.klikli_dev.modonomicon.platform.services.GuiHelper;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class FabricGuiHelper implements GuiHelper {

    private static FabricMultiLayerScreen multiLayerScreen;

    public static float getGuiFarPlane() {
        // 11000 units for the overlay background,
        // and 10000 units for each layered Screen,

        if(multiLayerScreen == null)
            return 11000.0F;

        return 11000.0F + 10000.0F * (1 + multiLayerScreen.guiLayers.size());
    }

    @Override
    public void pushGuiLayer(class_437 screen) {
        var minecraft = class_310.method_1551();

        var oldScreen = minecraft.field_1755;

        if(multiLayerScreen == null)
            multiLayerScreen = new FabricMultiLayerScreen();

        if (oldScreen != multiLayerScreen) {
            //if our layer screen is not the current screen then some other mod or vanilla/loader code has set a screen or null
            //we treat that as a clean slate.
            multiLayerScreen.guiLayers.clear();

            //then we put the previous screen as the first layer
            multiLayerScreen.guiLayers.push(oldScreen);
        }

        multiLayerScreen.guiLayers.push(screen);

        if (oldScreen != multiLayerScreen) {
            //init needs to happen after we added screens, because with an empty guiLayers stack we get errors
            multiLayerScreen.method_25423(minecraft, minecraft.method_22683().method_4486(), minecraft.method_22683().method_4502());
            minecraft.field_1755 = multiLayerScreen;
        }

        screen.method_25423(minecraft, minecraft.method_22683().method_4486(), minecraft.method_22683().method_4502());
        minecraft.method_44713().method_37015(screen.method_25435());
    }

    @Override
    public void popGuiLayer() {
        var minecraft = class_310.method_1551();

        if(multiLayerScreen == null)
            return;

        if (minecraft.field_1755 != multiLayerScreen) {
            //someone already overwrote screen, we exit
            return;
        }

        if (multiLayerScreen.guiLayers.size() == 1) {
            //we are at the last layer, so we close the screen
            //we do this here because then the last screen gets the related events from mc / modloader
            minecraft.method_1507(null);
        }

        var removed = multiLayerScreen.guiLayers.pop();
        removed.method_25432();

        if (!multiLayerScreen.guiLayers.isEmpty()) {
            minecraft.method_44713().method_37015(multiLayerScreen.guiLayers.peek().method_25435());
        }
    }

    @Override
    public class_437 getCurrentScreen() {
        if(multiLayerScreen == null)
            return class_310.method_1551().field_1755;

        return multiLayerScreen.guiLayers.isEmpty() ? class_310.method_1551().field_1755 : multiLayerScreen.guiLayers.peek();
    }

}
