/*
 * SPDX-FileCopyrightText: 2022 Authors of Patchouli
 *
 * SPDX-License-Identifier: MIT
 */
package com.klikli_dev.modonomicon.multiblock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_6539;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public abstract class AbstractMultiblock implements Multiblock {

    private final Map<class_2338, class_2586> blockEntityCache = new Object2ObjectOpenHashMap<>();
    public class_2960 id;
    protected int offX, offY, offZ;
    protected int viewOffX, viewOffY, viewOffZ;
    protected boolean symmetrical;
    class_1937 level;

    public static Map<Character, StateMatcher> mappingFromJson(JsonObject jsonMapping, class_7225.class_7874 provider) {
        var mapping = new HashMap<Character, StateMatcher>();
        for (Entry<String, JsonElement> entry : jsonMapping.entrySet()) {
            if (entry.getKey().length() != 1)
                throw new JsonSyntaxException("Mapping key needs to be only 1 character");
            char key = entry.getKey().charAt(0);
            var value = entry.getValue().getAsJsonObject();
            var stateMatcherType = class_2960.method_12829(class_3518.method_15265(value, "type"));
            var stateMatcher = LoaderRegistry.getStateMatcherJsonLoader(stateMatcherType).fromJson(value, provider);
            mapping.put(key, stateMatcher);
        }

        return mapping;
    }

    public static <T extends AbstractMultiblock> T additionalPropertiesFromJson(T multiblock, JsonObject json) {
        if (json.has("symmetrical")) {
            multiblock.symmetrical = class_3518.method_15270(json, "symmetrical");
        }
        if (json.has("offset")) {
            var jsonOffset = class_3518.method_15261(json, "offset");
            if (jsonOffset.size() != 3) {
                throw new JsonSyntaxException("Offset needs to be an array of 3 integers");
            }
            multiblock.offset(jsonOffset.get(0).getAsInt(), jsonOffset.get(1).getAsInt(), jsonOffset.get(2).getAsInt());
        }

        return multiblock;
    }

    public static class_2470 fixHorizontal(class_2470 rot) {
        return switch (rot) {
            case field_11463 -> class_2470.field_11465;
            case field_11465 -> class_2470.field_11463;
            default -> rot;
        };
    }

    public static class_2470 rotationFromFacing(class_2350 facing) {
        return switch (facing) {
            case field_11034 -> class_2470.field_11463;
            case field_11035 -> class_2470.field_11464;
            case field_11039 -> class_2470.field_11465;
            default -> class_2470.field_11467;
        };
    }

    public Multiblock setOffset(int x, int y, int z) {
        this.offX = x;
        this.offY = y;
        this.offZ = z;
        return this.setViewOffset(x, y, z);
    }

    public Multiblock setViewOffset(int x, int y, int z) {
        this.viewOffX = x;
        this.viewOffY = y;
        this.viewOffZ = z;
        return this;
    }

    public void setLevel(class_1937 level) {
        this.level = level;
    }

    @Override
    public Multiblock offset(int x, int y, int z) {
        return this.setOffset(this.offX + x, this.offY + y, this.offZ + z);
    }

    @Override
    public Multiblock offsetView(int x, int y, int z) {
        return this.setViewOffset(this.viewOffX + x, this.viewOffY + y, this.viewOffZ + z);
    }

    @Override
    public Multiblock setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        return this;
    }

    @Override
    public Multiblock setId(class_2960 res) {
        this.id = res;
        return this;
    }

    @Override
    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public void place(class_1937 world, class_2338 pos, class_2470 rotation) {
        this.setLevel(world);
        this.simulate(world, pos, rotation, false, false).getSecond().forEach(r -> {
            class_2338 placePos = r.getWorldPosition();
            class_2680 targetState = r.getStateMatcher().getDisplayedState(world.method_8510()).method_26186(rotation);

            if (!targetState.method_26215() && targetState.method_26184(world, placePos) && world.method_8320(placePos).method_45474()) {
                world.method_8501(placePos, targetState);
            }
        });
    }

    @Override
    public class_2470 validate(class_1937 world, class_2338 pos) {
        if (this.isSymmetrical() && this.validate(world, pos, class_2470.field_11467)) {
            return class_2470.field_11467;
        } else {
            for (class_2470 rot : class_2470.values()) {
                if (this.validate(world, pos, rot)) {
                    return rot;
                }
            }
        }
        return null;
    }

    @Override
    public boolean validate(class_1937 world, class_2338 pos, class_2470 rotation) {
        this.setLevel(world);
        Pair<class_2338, Collection<SimulateResult>> sim = this.simulate(world, pos, rotation, false, false);

        return sim.getSecond().stream().allMatch(r -> {
            class_2338 checkPos = r.getWorldPosition();
            TriPredicate<class_1922, class_2338, class_2680> pred = r.getStateMatcher().getStatePredicate();
            class_2680 state = world.method_8320(checkPos).method_26186(fixHorizontal(rotation));

            return pred.test(world, checkPos, state);
        });
    }

    @Override
    public abstract class_2382 getSize();

    @Override
    public class_2382 getOffset() {
        return new class_2382(this.offX, this.offY, this.offZ);
    }

    @Override
    public class_2382 getViewOffset() {
        return new class_2382(this.viewOffX, this.viewOffY, this.viewOffZ);
    }

    void setViewOffset() {
        this.setViewOffset(this.offX, this.offY, this.offZ);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object o) {

        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        var that = (AbstractMultiblock) o;
        return this.id.equals(that.id);
    }

    @Nullable
    @Override
    public class_2586 method_8321(class_2338 pos) {
        class_2680 state = this.method_8320(pos);
        if (state.method_26204() instanceof class_2343 eb) {
            return this.blockEntityCache.computeIfAbsent(pos.method_10062(), p -> eb.method_10123(p, state));
        }
        return null;
    }

    @Override
    public class_3610 method_8316(class_2338 pos) {
        return class_3612.field_15906.method_15785();
    }

    @Override
    public float method_24852(class_2350 direction, boolean shaded) {
        return 1.0F;
    }

    @Override
    public class_3568 method_22336() {
        return null;
    }

    @Override
    public int method_23752(class_2338 pos, class_6539 color) {
        var plains = this.level.method_30349().method_30530(class_7924.field_41236)
                .method_31140(class_1972.field_9451);
        return color.getColor(plains, pos.method_10263(), pos.method_10260());
    }

    @Override
    public int method_8314(class_1944 type, class_2338 pos) {
        return 15;
    }

    @Override
    public int method_22335(class_2338 pos, int ambientDarkening) {
        return 15 - ambientDarkening;
    }

    // These heights were assumed based being derivative of old behavior, but it may be ideal to change
    @Override
    public int method_31605() {
        return 255;
    }

    @Override
    public int method_31607() {
        return 0;
    }
}
