/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

/**
 * Matches a block, ignoring the BlockState properties.
 */
public class BlockMatcher implements StateMatcher {
    public static final class_2960 TYPE = Modonomicon.loc("block");

    private final class_2680 displayState;
    private final class_2248 block;
    private final TriPredicate<class_1922, class_2338, class_2680> predicate;

    protected BlockMatcher(class_2680 displayState, class_2248 block) {
        this.displayState = displayState;
        this.block = block;
        this.predicate = (blockGetter, blockPos, blockState) ->
                blockState.method_26204() == block;
    }

    public static BlockMatcher from(class_2248 block) {
        return new BlockMatcher(null, block);
    }

    public static BlockMatcher from(class_2680 displayState, class_2248 block) {
        return new BlockMatcher(displayState, block);
    }

    public static BlockMatcher fromJson(JsonObject json, class_7225.class_7874 provider) {
        class_2680 displayState = null;
        if (json.has("display")) {
            try {
                displayState = class_2259.method_41955(class_7923.field_41175, new StringReader(class_3518.method_15265(json, "display")), false).comp_622();
            } catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for BlockMatcher.", e);
            }
        }

        try {
            var blockRL = class_2960.method_12829(class_3518.method_15265(json, "block"));
            var block = class_7923.field_41175.method_63535(blockRL);

            return new BlockMatcher(displayState, block);
        } catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse Block from json member \"block\" for BlockMatcher", e);
        }
    }

    public static BlockMatcher fromNetwork(class_2540 buffer) {
        try {
            class_2680 displayState = null;
            if (buffer.readBoolean())
                displayState = class_2259.method_41955(class_7923.field_41175, new StringReader(buffer.method_19772()), false).comp_622();

            var block = class_7923.field_41175.method_63535(buffer.method_10810());
            return new BlockMatcher(displayState, block);
        } catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockMatcher from network.", e);
        }
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }

    @Override
    public class_2680 getDisplayedState(long ticks) {
        return this.displayState == null ? this.block.method_9564() : this.displayState;
    }

    @Override
    public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.method_52964(this.displayState != null);
        if (this.displayState != null)
            buffer.method_10814(class_2259.method_9685(this.displayState));
        buffer.method_10812(class_7923.field_41175.method_10221(this.block));
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.block, this.displayState);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        var that = (BlockMatcher) o;
        return this.block.equals(that.block) && this.displayState.equals(that.displayState);
    }
}
