/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class BookCategoryBackgroundParallaxLayer {
    public static final Codec<BookCategoryBackgroundParallaxLayer> CODEC = RecordCodecBuilder.create((builder) ->
            builder.group(
                    class_2960.field_25139.fieldOf("background").forGetter((overlay) -> overlay.background),
                    Codec.FLOAT.optionalFieldOf("speed", 0.5f).forGetter((overlay) -> overlay.speed),
                    Codec.FLOAT.optionalFieldOf("vanishZoom", -1.0f).forGetter((overlay) -> overlay.vanishZoom)
            ).apply(builder, BookCategoryBackgroundParallaxLayer::new));

    /**
     * The texture to use for this layer.
     */
    protected class_2960 background;

    /**
     * The speed at which this layer moves.
     */
    protected float speed;

    /**
     * The zoom level at which this layer vanishes.
     */
    protected float vanishZoom;

    public BookCategoryBackgroundParallaxLayer(class_2960 background) {
        this(background, 0.5f, -1.0f);
    }

    public BookCategoryBackgroundParallaxLayer(class_2960 background, float speed, float vanishZoom) {
        this.background = background;
        this.speed = speed;
        this.vanishZoom = vanishZoom;
    }

    public static BookCategoryBackgroundParallaxLayer fromJson(JsonObject json) {
        return BookCategoryBackgroundParallaxLayer.CODEC.parse(JsonOps.INSTANCE, json).getOrThrow();
    }

    public static List<BookCategoryBackgroundParallaxLayer> fromJson(JsonArray json) {
        return StreamSupport.stream(json.spliterator(), false)
                .map(JsonElement::getAsJsonObject)
                .map(BookCategoryBackgroundParallaxLayer::fromJson)
                .collect(Collectors.toList());
    }

    public static BookCategoryBackgroundParallaxLayer fromNetwork(class_2540 buffer) {
        return buffer.method_49394(BookCategoryBackgroundParallaxLayer.CODEC);
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_49395(BookCategoryBackgroundParallaxLayer.CODEC, this);
    }

    public class_2960 getBackground() {
        return this.background;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getVanishZoom() {
        return this.vanishZoom;
    }

}
