/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9129;

public class RenderedBookTextHolder extends BookTextHolder {

    private final BookTextHolder original;
    private final List<class_5250> renderedText;

    public RenderedBookTextHolder(BookTextHolder original, List<class_5250> renderedText) {
        this.original = original;
        this.renderedText = renderedText;
    }

    public List<class_5250> getRenderedText() {
        return this.renderedText;
    }

    @Override
    public String getString() {
        return this.original.getString();
    }

    @Override
    public class_2561 getComponent() {
        return this.original.getComponent();
    }

    @Override
    public boolean isEmpty() {
        return this.getRenderedText().isEmpty();
    }

    @Override
    public boolean hasComponent() {
        return this.original.hasComponent();
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        this.original.toNetwork(buffer);
    }
}
