/*
 * SPDX-FileCopyrightText: 2024 DaFuqs
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

/**
 * This BookCondition evaluates to true
 * if a category has at least
 */
public class BookCategoryHasVisibleEntriesCondition extends BookCondition {
    
    protected class_2960 categoryId;
    
    public BookCategoryHasVisibleEntriesCondition(class_2561 tooltip, class_2960 categoryId) {
        super(tooltip);
        this.categoryId = categoryId;
    }
    
    public static BookCategoryHasVisibleEntriesCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        var categoryPath = class_3518.method_15265(json, "category_id");
        var categoryId = categoryPath.contains(":") ?
                class_2960.method_60654(categoryPath) :
                class_2960.method_60655(conditionParentId.method_12836(), categoryPath);

        class_2561 tooltip = class_2561.method_43469(ModonomiconConstants.I18n.Tooltips.CONDITION_CATEGORY_HAS_VISIBLE_ENTRIES, categoryId.method_42094());
        return new BookCategoryHasVisibleEntriesCondition(tooltip, categoryId);
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.tooltip != null);
        if (this.tooltip != null) {
            class_8824.field_48540.encode(buffer, this.tooltip);
        }
        buffer.method_10812(this.categoryId);
    }
    
    public static BookCategoryHasVisibleEntriesCondition fromNetwork(class_9129 buffer) {
        var tooltip = buffer.readBoolean() ? class_8824.field_48540.decode(buffer) : null;
        var entryId = buffer.method_10810();
        return new BookCategoryHasVisibleEntriesCondition(tooltip, entryId);
    }
    
    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Condition.CATEGORY_HAS_VISIBLE_ENTRIES;
    }
    
    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        var category = context.book.getCategory(this.categoryId);
        if (category == null) {
            throw new IllegalArgumentException("Category with id " + this.categoryId + " not found in book " + context.getBook().getId() + "for BookCategoryHasVisibleEntriesCondition. This happened while trying to unlock " + context);
        }

        if(category.getEntries().isEmpty()) {
            return false;
        }

        for(var entry : category.getEntries().values()) {
            if(entry.getEntryDisplayState(player).isVisible()) {
                return true;
            }
        }

        return false;
    }
    
    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext entryContext) {
            this.tooltip = class_2561.method_43469(ModonomiconConstants.I18n.Tooltips.CONDITION_CATEGORY_HAS_VISIBLE_ENTRIES, class_2561.method_43471(entryContext.getBook().getEntry(this.categoryId).getName()));
        }
        return super.getTooltip(player, context);
    }
}
