/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Condition;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Tooltips;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public class BookModLoadedCondition extends BookCondition {

    protected String modId;

    public BookModLoadedCondition(class_2561 component, String modId) {
        super(component);
        this.modId = modId;
    }

    public static BookModLoadedCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        var modId = class_3518.method_15265(json, "mod_id");

        //default tooltip
        var tooltip = class_2561.method_43469(Tooltips.CONDITION_MOD_LOADED, modId);

        if (json.has("tooltip")) {
            tooltip = tooltipFromJson(json, provider);
        }

        return new BookModLoadedCondition(tooltip, modId);
    }

    public static BookModLoadedCondition fromNetwork(class_9129 buffer) {
        var tooltip = buffer.readBoolean() ? class_8824.field_48540.decode(buffer) : null;
        var modId = buffer.method_19772();
        return new BookModLoadedCondition(tooltip, modId);
    }

    @Override
    public class_2960 getType() {
        return Condition.MOD_LOADED;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.tooltip != null);
        if (this.tooltip != null) {
            class_8824.field_48540.encode(buffer, this.tooltip);
        }
        buffer.method_10814(this.modId);
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        return Services.PLATFORM.isModLoaded(this.modId);
    }

    @Override
    public boolean testOnLoad() {
        return Services.PLATFORM.isModLoaded(this.modId);
    }
}
