/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.node.BookParentNodeScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.minecraft.class_9848;

public class CategoryButton extends class_4185 {

    private final BookParentNodeScreen parent;
    private final BookCategory category;

    public CategoryButton(BookParentNodeScreen parent, BookCategory category, int pX, int pY, int width, int height, class_4241 pOnPress, class_7919 tooltip) {
        super(pX, pY, width, height, class_2561.method_43470(""), pOnPress, class_4185.field_40754);
        this.method_47400(tooltip);
        this.parent = parent;
        this.category = category;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    @Override
    public void method_48579(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.field_22764) {
            guiGraphics.method_51448().pushMatrix();
            int xOffset = this.getCategory().getBook().getCategoryButtonXOffset();
            guiGraphics.method_51448().translate(xOffset, 0);

            int texX = 0;
            int texY = 145;

            int renderX = this.method_46426();
            int renderWidth = this.field_22758;

            int color;
            if (BookGuiManager.get().openBookCategoryScreen != null && this.category == BookGuiManager.get().openBookCategoryScreen.getCategory()) {
                renderX -= 3;
                renderWidth += 3;
                color = class_9848.method_61318(1.0f, 1.0F, 1.0F, 1.0F);
            } else if (this.method_49606()) {
                renderX -= 1;
                renderWidth += 1;
                color = class_9848.method_61318(1.0f, 1.0F, 1.0F, 1.0F);
            } else {
                color = class_9848.method_61318(1.0f, 0.8F, 0.8F, 0.8F);
            }

            //draw category button background
//            RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
            guiGraphics.method_25291(class_10799.field_56883, this.parent.getBookOverviewTexture(), renderX, this.method_46427(), texX, texY, renderWidth, this.field_22759, 256, 256, color);

            //then draw icon
            int iconSize = 16;
            int centerIconOffset = iconSize / 2;
            float scale = this.getCategory().getBook().getCategoryButtonIconScale();

            guiGraphics.method_51448().pushMatrix();
            //TODO had a +100 z here
            guiGraphics.method_51448().translate(renderX + 8, this.method_46427() + 2); //move to desired render location
            //not sure why in 1.21.6+ it is 2 instead of 20, but it works ... otherwise the icons render below
//            guiGraphics.pose().translate(renderX + 8, this.getY() + 20); //move to desired render location

            //now scale around center
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate(centerIconOffset, centerIconOffset);
            guiGraphics.method_51448().scale(scale, scale);
            guiGraphics.method_51448().translate(-centerIconOffset, -centerIconOffset);

            this.category.getIcon().render(guiGraphics, 0, 0);

            guiGraphics.method_51448().popMatrix();
            guiGraphics.method_51448().popMatrix();
            guiGraphics.method_51448().popMatrix();
        }
    }
}
