/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.command;

import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Command;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.networking.SendUnlockCodeToClientMessage;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;

public class SaveUnlocksCommand implements com.mojang.brigadier.Command<class_2168> {

    private static final SaveUnlocksCommand CMD = new SaveUnlocksCommand();


    public static ArgumentBuilder<class_2168, ?> register(CommandDispatcher<class_2168> dispatcher) {

        return class_2170.method_9247("save_progress")
                .requires(cs -> cs.method_9259(1))
                .then(class_2170.method_9244("book", class_2232.method_9441())
                        .suggests(ResetBookUnlocksCommand.SUGGEST_BOOK)
                        .executes(CMD));

    }


    @Override
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        var book = ResetBookUnlocksCommand.getBook(context, "book");

        var code = BookUnlockStateManager.get().getUnlockCodeFor(context.getSource().method_44023(), book);

        Services.NETWORK.sendToSplit(context.getSource().method_44023(), new SendUnlockCodeToClientMessage(code));

        context.getSource().method_9226(() -> class_2561.method_43469(Command.SUCCESS_SAVE_PROGRESS, class_2561.method_43471(book.getName())), true);
        return 1;
    }
}
