/*
 * SPDX-FileCopyrightText: 2024 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.gui;

import org.jetbrains.annotations.Nullable;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.class_128;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5195;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;

public class FabricMultiLayerScreen extends class_437 {

    public final Stack<class_437> guiLayers = new Stack<>();

    protected FabricMultiLayerScreen() {
        super(class_2561.method_43473());
    }

    @Override
    public void method_25410(class_310 minecraft, int width, int height) {
        this.guiLayers.forEach(screen -> screen.method_25410(minecraft, width, height));
    }

    @Override
    public void method_47413(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.method_51448().pushMatrix();
        for (int i = 0; i < this.guiLayers.size(); i++) {
            class_437 layer = this.guiLayers.get(i);
            if (i == this.guiLayers.size() - 1) {
                // This is the last layer, it gets actual mouse over
                layer.method_47413(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            } else {
                layer.method_47413(pGuiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, pPartialTick);
            }
        }
        pGuiGraphics.method_51448().popMatrix();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        //do nothing
    }


    @Override
    public void method_37064(boolean onlyNarrateNew) {
        //do nothing
    }

    @Override
    public boolean method_25421() {
        return this.guiLayers.peek().method_25421();
    }


    @Override
    public void method_49589() {
        this.guiLayers.peek().method_49589();
    }


    @Override
    public int method_48590() {
        return this.guiLayers.peek().method_48590();
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        this.guiLayers.peek().method_16014(mouseX, mouseY);
    }

    @Nullable
    @Override
    public class_8016 method_48205(class_8023 event) {
        return this.guiLayers.peek().method_48205(event);
    }

    @Nullable
    @Override
    public class_8016 method_48218() {
        return this.guiLayers.peek().method_48218();
    }

    @Override
    public boolean method_25370() {
        return this.guiLayers.peek().method_25370();
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        return this.guiLayers.peek().method_25400(codePoint, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.guiLayers.peek().method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.guiLayers.peek().method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.guiLayers.peek().method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.guiLayers.peek().method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.guiLayers.peek().method_25402(mouseX, mouseY, button);
    }

    @Override
    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        return this.guiLayers.peek().method_19355(mouseX, mouseY);
    }

    @Nullable
    @Override
    public class_364 method_25399() {
        return this.guiLayers.peek().method_25399();
    }

    @Override
    public void method_25365(boolean focused) {
        this.guiLayers.peek().method_25365(focused);
    }

    @Override
    public void method_25395(@Nullable class_364 focused) {
        this.guiLayers.peek().method_25395(focused);
    }

    @Nullable
    @Override
    public class_5195 method_50024() {
        return this.guiLayers.peek().method_50024();
    }

    @Override
    public class_8030 method_48202() {
        return this.guiLayers.peek().method_48202();
    }

    @Override
    public void method_25423(class_310 minecraft, int width, int height) {
        this.guiLayers.peek().method_25423(minecraft, width, height);
    }

    @Override
    public void method_65027(class_128 crashReport) {
        this.guiLayers.peek().method_65027(crashReport);
    }

    @Override
    public class_327 method_64506() {
        return this.guiLayers.peek().method_64506();
    }

    @Override
    public boolean method_64507() {
        return this.guiLayers.peek().method_64507();
    }

    @Override
    public void method_61040(boolean bl) {
        this.guiLayers.peek().method_61040(bl);
    }

    @Override
    public void method_37071() {
        this.guiLayers.peek().method_37071();
    }

    @Override
    public void method_37070() {
        this.guiLayers.peek().method_37070();
    }

    @Override
    public void method_37069() {
        this.guiLayers.peek().method_37069();
    }

    @Override
    public void method_37068() {
        this.guiLayers.peek().method_37068();
    }

    @Override
    public void method_29638(List<Path> packs) {
        this.guiLayers.peek().method_29638(packs);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.guiLayers.peek().method_25405(mouseX, mouseY);
    }

    @Override
    public void method_52752(class_332 guiGraphics) {
        this.guiLayers.peek().method_52752(guiGraphics);
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.guiLayers.peek().method_25420(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void method_25432() {
        this.guiLayers.peek().method_25432();
    }

    @Override
    public void method_25393() {
        this.guiLayers.peek().method_25393();
    }

    @Override
    public List<? extends class_364> method_25396() {
        return this.guiLayers.peek().method_25396();
    }


    @Override
    public boolean method_25430(@Nullable class_2583 style) {
        return this.guiLayers.peek().method_25430(style);
    }

    @Override
    public void method_25419() {
        this.guiLayers.peek().method_25419();
    }

    @Override
    public boolean method_25422() {
        return this.guiLayers.peek().method_25422();
    }

    @Override
    public void method_48267() {
        this.guiLayers.peek().method_48267();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.guiLayers.peek().method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public class_2561 method_25435() {
        return this.guiLayers.peek().method_25435();
    }

    @Override
    public class_2561 method_25440() {
        return this.guiLayers.peek().method_25440();
    }
}
