/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.api.datagen.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Page;
import com.klikli_dev.modonomicon.api.datagen.book.BookTextHolderModel;
import com.klikli_dev.modonomicon.book.page.BookSpotlightPage;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.JsonOps;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

public class BookSpotlightPageModel extends BookPageModel<BookSpotlightPageModel> {
    protected Either<class_1799, class_1856> item = Either.right(class_1856.field_9017);
    protected BookTextHolderModel title = new BookTextHolderModel("");
    protected BookTextHolderModel text = new BookTextHolderModel("");

    protected BookSpotlightPageModel() {
        super(Page.SPOTLIGHT);
    }

    public static BookSpotlightPageModel create() {
        return new BookSpotlightPageModel();
    }

    public BookTextHolderModel getTitle() {
        return this.title;
    }

    public Either<class_1799, class_1856> getItem() {
        return this.item;
    }

    public BookTextHolderModel getText() {
        return this.text;
    }

    @Override
    public JsonObject toJson(class_2960 entryId, class_7225.class_7874 provider) {
        var json = super.toJson(entryId, provider);
        json.add("title", this.title.toJson(provider));
        json.add("item",
                BookSpotlightPage.ITEM_CODEC.encodeStart(provider.method_57093(JsonOps.INSTANCE), this.item).getOrThrow()
        );
        json.add("text", this.text.toJson(provider));
        return json;
    }

    public BookSpotlightPageModel withTitle(String title) {
        this.title = new BookTextHolderModel(title);
        return this;
    }

    public BookSpotlightPageModel withTitle(class_2561 title) {
        this.title = new BookTextHolderModel(title);
        return this;
    }

    public BookSpotlightPageModel withItem(class_1856 item) {
        this.item = Either.right(item);
        return this;
    }

    public BookSpotlightPageModel withItem(class_1799 item) {
        this.item = Either.left(item);
        return this;
    }

    public BookSpotlightPageModel withItem(class_1935 item) {
        this.item = Either.left(new class_1799(item));
        return this;
    }

    public BookSpotlightPageModel withItem(class_1792 item) {
        this.item = Either.left(new class_1799(item));
        return this;
    }

    public BookSpotlightPageModel withText(String text) {
        this.text = new BookTextHolderModel(text);
        return this;
    }

    public BookSpotlightPageModel withText(class_2561 text) {
        this.text = new BookTextHolderModel(text);
        return this;
    }
}
