// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT


package com.klikli_dev.modonomicon.book;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

import java.util.function.IntFunction;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public enum BookDisplayMode implements class_3542 {
    NODE("node"),
    INDEX("index");

    public static final class_3542.class_7292<BookDisplayMode> CODEC = class_3542.method_28140(BookDisplayMode::values);
    private static final IntFunction<BookDisplayMode> BY_ID = class_7995.method_47914(Enum::ordinal, values(), class_7995.class_7996.field_41665);
    public static final class_9139<ByteBuf, BookDisplayMode> STREAM_CODEC = class_9135.method_56375(BY_ID, BookDisplayMode::ordinal);
    private final String name;

    BookDisplayMode(String name) {
        this.name = name;
    }

    public static BookDisplayMode byName(String pName) {
        return CODEC.method_42633(pName);
    }

    public static BookDisplayMode byId(int pId) {
        return BY_ID.apply(pId);
    }

    @Override
    public @NotNull String method_15434() {
        return this.name;
    }
}
