/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Condition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public class BookFalseCondition extends BookCondition {

    public BookFalseCondition(class_2561 component) {
        super(component);
    }

    public static BookFalseCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        var tooltip = tooltipFromJson(json, provider);
        return new BookFalseCondition(tooltip);
    }

    public static BookFalseCondition fromNetwork(class_9129 buffer) {
        var tooltip = buffer.readBoolean() ? class_8824.field_48540.decode(buffer) : null;
        return new BookFalseCondition(tooltip);
    }

    @Override
    public class_2960 getType() {
        return Condition.FALSE;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.tooltip != null);
        if (this.tooltip != null) {
            class_8824.field_48540.encode(buffer, this.tooltip);
        }
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        return false;
    }
}
