/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Page;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class BookEmptyPage extends BookPage {

    public BookEmptyPage(String anchor, BookCondition condition) {
        super(anchor, condition);
    }

    public static BookEmptyPage fromJson(class_2960 entryId, JsonObject json, class_7225.class_7874 provider) {
        var anchor = class_3518.method_15253(json, "anchor", "");
        var condition = json.has("condition")
                ? BookCondition.fromJson(entryId, json.getAsJsonObject("condition"), provider)
                : new BookNoneCondition();
        return new BookEmptyPage(anchor, condition);
    }

    public static BookEmptyPage fromNetwork(class_9129 buffer) {
        var anchor = buffer.method_19772();
        var condition = BookCondition.fromNetwork(buffer);
        return new BookEmptyPage(anchor, condition);
    }

    @Override
    public class_2960 getType() {
        return Page.EMPTY;
    }

    @Override
    public boolean matchesQuery(String query) {
        return false;
    }
}
