/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_7225;

public class BookStatesSaveData extends class_18 {
    public static final Codec<BookStatesSaveData> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.unboundedMap(Codecs.UUID, BookUnlockStates.CODEC).fieldOf("unlockStates").forGetter((state) -> state.unlockStates),
            Codec.unboundedMap(Codecs.UUID, BookVisualStates.CODEC).fieldOf("visualStates").forGetter((state) -> state.visualStates)
    ).apply(instance, BookStatesSaveData::new));

    public static final String ID = "modonomicon_book_states";

    public Map<UUID, BookUnlockStates> unlockStates;
    public Map<UUID, BookVisualStates> visualStates;

    public BookStatesSaveData() {
        this(Object2ObjectMaps.emptyMap(), Object2ObjectMaps.emptyMap());
    }

    public BookStatesSaveData(Map<UUID, BookUnlockStates> unlockStates, Map<UUID, BookVisualStates> visualStates) {
        this.unlockStates = Object2ObjectMaps.synchronize(new Object2ObjectOpenHashMap<>(unlockStates));
        this.visualStates = Object2ObjectMaps.synchronize(new Object2ObjectOpenHashMap<>(visualStates));

        this.method_80();
    }

    public static BookStatesSaveData load(class_2487 pCompoundTag, class_7225.class_7874 pHolderProvider) {
        return CODEC.parse(class_2509.field_11560, pCompoundTag.method_10580("bookStates")).result().orElse(new BookStatesSaveData());
    }

    public BookUnlockStates getUnlockStates(UUID playerUUID) {
        return this.unlockStates.computeIfAbsent(playerUUID, (uuid) -> {
            this.method_80();
            return new BookUnlockStates();
        });
    }

    public BookVisualStates getVisualStates(UUID playerUUID) {
        return this.visualStates.computeIfAbsent(playerUUID, (uuid) -> {
            this.method_80();
            return new BookVisualStates();
        });
    }

    @Override
    public @NotNull class_2487 method_75(class_2487 compoundTag, class_7225.@NotNull class_7874 pHolderProvider) {
        compoundTag.method_10566("bookStates", CODEC.encodeStart(class_2509.field_11560, this).result().orElseThrow());
        return compoundTag;
    }
}
