/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookScreenWithButtons;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_757;

public class BookButton extends class_4185 {

    protected final BookScreenWithButtons parent;
    protected final int u, v;
    protected final Supplier<Boolean> displayCondition;
    protected final List<class_2561> tooltip;

    public BookButton(BookScreenWithButtons parent, int x, int y, int u, int v, int w, int h, class_2561 pMessage, class_4241 onPress, class_2561... tooltip) {
        this(parent, x, y, u, v, w, h, () -> true, pMessage, onPress, tooltip);
    }

    public BookButton(BookScreenWithButtons parent, int x, int y, int u, int v, int w, int h, Supplier<Boolean> displayCondition, class_2561 pMessage, class_4241 onPress, class_2561... tooltip) {
        super(x, y, w, h, pMessage, onPress, class_4185.field_40754);
        this.parent = parent;
        this.u = u;
        this.v = v;
        this.displayCondition = displayCondition;
        this.tooltip = List.of(tooltip);
    }

    @Override
    public final void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.field_22763 = this.field_22764 = this.displayCondition.get();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor(1F, 1F, 1F, 1F);

        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();

        //if focused we go to the right of our normal button (instead of down, like mc buttons do)
        BookContentRenderer.drawFromContentTexture(guiGraphics, this.parent.getBook(), this.method_46426(), this.method_46427(), this.u + (this.method_49606() ? this.field_22758 : 0), this.v, this.field_22758, this.field_22759);
        if (this.method_49606()) {
            this.parent.setTooltip(this.tooltip);
        }
    }
}
