// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.client.gui.book.entry;

import I;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.CommandLink;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.klikli_dev.modonomicon.platform.ClientServices;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public interface ContentRenderingScreen {

    default class_437 asScreen(){
        return (class_437) this;
    }

    Book getBook();

    BookContentEntry getEntry();

    class_327 getFont();

    int getTicksInBook();

    int getBookLeft();

    int getBookTop();

    void setTooltipStack(class_1799 stack);

    void setTooltipStack(FluidHolder stack);

    boolean isHoveringItemLink();

    void isHoveringItemLink(boolean value);

    default boolean isMouseInRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx;
        double my = absMy;

        return mx > x && my > y && mx <= (x + w) && my <= (y + h);
    }

    default void renderItemStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1799 stack) {
        if (stack.method_7960() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }

        guiGraphics.method_51427(stack, x, y);
        guiGraphics.method_51431(this.getFont(), stack, x, y);

        if (this.isMouseInRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    default void renderItemStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<class_1799> stacks) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, stacks, -1);
    }

    default void renderItemStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<class_1799> stacks, int countOverride) {
        var filteredStacks = PageRendererRegistry.filterRenderableItemStacks(stacks);
        if (filteredStacks.size() > 0) {
            var currentStack = filteredStacks.get((this.getTicksInBook() / 20) % filteredStacks.size());
            this.renderItemStack(guiGraphics, x, y, mouseX, mouseY, countOverride > 0 ? currentStack.method_46651(countOverride) : currentStack);
        }
    }

    default void renderIngredient(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1856 ingr) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.method_8105()), -1);
    }

    default void renderIngredient(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1856 ingr, int countOverride) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.method_8105()), countOverride);
    }

    default void renderFluidStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack) {
        this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, stack, FluidHolder.BUCKET_VOLUME);
    }

    default void renderFluidStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack, int capacity) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }

        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x, y, 0);
        ClientServices.FLUID.drawFluid(guiGraphics, 18, 18, stack, capacity);
        guiGraphics.method_51448().method_22909();

        if (this.isMouseInRange(mouseX, mouseY, x, y, 18, 18)) {
            this.setTooltipStack(stack);
        }
    }

    default void renderFluidStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks) {
        this.renderFluidStacks(guiGraphics, x, y, mouseX, mouseY, stacks, FluidHolder.BUCKET_VOLUME);
    }

    default void renderFluidStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks, int capacity) {
        var filteredStacks = PageRendererRegistry.filterRenderableFluidStacks(stacks);
        if (filteredStacks.size() > 0) {
            this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, filteredStacks.get((this.getTicksInBook() / 20) % filteredStacks.size()), capacity);
        }
    }

    /**
     * Our copy of guiGraphics.renderComponentHoverEffect(); to handle book links
     */
    default void renderComponentHoverEffect(class_332 guiGraphics, @Nullable class_2583 style, int mouseX, int mouseY) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0, 0, 1000);
        var newStyle = style;
        if (style != null && style.method_10969() != null) {
            if (style.method_10969().method_10892() == class_2568.class_5247.field_24342) {
                var clickEvent = style.method_10970();
                if (clickEvent != null) {
                    if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {

                        //handle book links -> check if locked
                        if (BookLink.isBookLink(clickEvent.method_10844())) {
                            var link = BookLink.from(this.getBook(), clickEvent.method_10844());
                            var book = BookDataManager.get().getBook(link.bookId);
                            if (link.entryId != null) {
                                var entry = book.getEntry(link.entryId);

                                Integer page = link.pageNumber;
                                if (link.pageAnchor != null) {
                                    page = entry.getPageNumberForAnchor(link.pageAnchor);
                                }

                                //if locked, append lock warning
                                //handleComponentClicked will prevent the actual click

                                if (!BookUnlockStateManager.get().isUnlockedFor(class_310.method_1551().field_1724, entry)) {
                                    var oldComponent = style.method_10969().method_10891(class_2568.class_5247.field_24342);

                                    var newComponent = class_2561.method_43469(
                                            ModonomiconConstants.I18n.Gui.HOVER_BOOK_LINK_LOCKED,
                                            oldComponent,
                                            class_2561.method_43471(ModonomiconConstants.I18n.Gui.HOVER_BOOK_ENTRY_LINK_LOCKED_INFO)
                                                    .method_27694(s -> s.method_36139(0xff0015).method_10982(true))
                                                    .method_27693("\n")
                                                    .method_10852(
                                                            class_2561.method_43469(
                                                                    ModonomiconConstants.I18n.Gui.HOVER_BOOK_ENTRY_LINK_LOCKED_INFO_HINT,
                                                                    class_2561.method_43471(entry.getCategory().getName())
                                                                            .method_27694(s -> s.method_10977(class_124.field_1080).method_10978(true))
                                                            ).method_27694(s -> s.method_10982(false).method_10977(class_124.field_1068))
                                                    )
                                    );

                                    newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, newComponent));
                                } else if (page != null && !BookUnlockStateManager.get().isUnlockedFor(class_310.method_1551().field_1724, entry.getPages().get(page))) {
                                    var oldComponent = style.method_10969().method_10891(class_2568.class_5247.field_24342);

                                    var newComponent = class_2561.method_43469(
                                            ModonomiconConstants.I18n.Gui.HOVER_BOOK_LINK_LOCKED,
                                            oldComponent,
                                            class_2561.method_43471(ModonomiconConstants.I18n.Gui.HOVER_BOOK_PAGE_LINK_LOCKED_INFO)
                                                    .method_27694(s -> s.method_36139(0xff0015).method_10982(true))
                                                    .method_27693("\n")
                                                    .method_10852(
                                                            class_2561.method_43469(
                                                                    ModonomiconConstants.I18n.Gui.HOVER_BOOK_PAGE_LINK_LOCKED_INFO_HINT,
                                                                    class_2561.method_43471(entry.getName())
                                                                            .method_27694(s -> s.method_10977(class_124.field_1080).method_10978(true)),
                                                                    class_2561.method_43471(entry.getCategory().getName())
                                                                            .method_27694(s -> s.method_10977(class_124.field_1080).method_10978(true))
                                                            ).method_27694(s -> s.method_10982(false).method_10977(class_124.field_1068))
                                                    )
                                    );

                                    newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, newComponent));
                                }
                            }
                        }
                    }

                    if (clickEvent.method_10845() == class_2558.class_2559.field_11750) {
                        if (CommandLink.isCommandLink(clickEvent.method_10844())) {
                            var link = CommandLink.from(this.getBook(), clickEvent.method_10844());
                            var book = BookDataManager.get().getBook(link.bookId);
                            if (link.commandId != null) {
                                var command = book.getCommand(link.commandId);

                                var oldComponent = style.method_10969().method_10891(class_2568.class_5247.field_24342);

                                if (!BookUnlockStateManager.get().canRunFor(class_310.method_1551().field_1724, command)) {
                                    var hoverComponent = class_2561.method_43471(ModonomiconConstants.I18n.Gui.HOVER_COMMAND_LINK_UNAVAILABLE).method_27692(class_124.field_1061);
                                    newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, hoverComponent));
                                    oldComponent = hoverComponent;
                                }

                                if (class_437.method_25442()) {
                                    var newComponent = oldComponent.method_27661().method_10852(class_2561.method_43470("\n")).method_10852(
                                            class_2561.method_43470(command.getCommand()).method_27692(class_124.field_1080));
                                    newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, newComponent));
                                }
                            }
                        }
                    }
                }
            }
        }

        style = newStyle;

        //original GuiGraphics.renderComponentHoverEffect(pPoseStack, newStyle, mouseX, mouseY);
        // our own copy of the render code that limits width for the show_text action to not go out of screen
        if (style != null && style.method_10969() != null) {
            class_2568 hoverevent = style.method_10969();
            class_2568.class_5249 hoverevent$itemstackinfo = hoverevent.method_10891(class_2568.class_5247.field_24343);
            if (hoverevent$itemstackinfo != null) {
                //special handling for item link hovers -> we append another line in this.getTooltipFromItem
                if (style.method_10970() != null)// && ItemLinkRenderer.isItemLink(style.getClickEvent().getValue()))
                    this.isHoveringItemLink(true);

                //temporarily modify width to force forge to handle wrapping correctly
                var backupWidth = this.asScreen().field_22789;
                this.asScreen().field_22789 = this.asScreen().field_22789 / 2; //not quite sure why exaclty / 2 works, but then forge wrapping handles it correctly on gui scale 3+4
                guiGraphics.method_51446(this.getFont(), hoverevent$itemstackinfo.method_27683(), mouseX, mouseY);
                this.asScreen().field_22789 = backupWidth;

                //then we reset so other item tooltip renders are not affected
                this.isHoveringItemLink(false);
            } else {
                class_2568.class_5248 hoverevent$entitytooltipinfo = hoverevent.method_10891(class_2568.class_5247.field_24344);
                if (hoverevent$entitytooltipinfo != null) {
                    if (class_310.method_1551().field_1690.field_1827) {
                        guiGraphics.method_51434(this.getFont(), hoverevent$entitytooltipinfo.method_27682(), mouseX, mouseY);
                    }
                } else {
                    class_2561 component = hoverevent.method_10891(class_2568.class_5247.field_24342);
                    if (component != null) {
                        //var width = Math.max(this.width / 2, 200); //original width calc
                        var width = (this.asScreen().field_22789 / 2) - mouseX - 10; //our own
                        guiGraphics.method_51447(this.getFont(), this.getFont().method_1728(component, width), mouseX, mouseY);
                    }
                }
            }

        }
        guiGraphics.method_51448().method_22909();
    }
}
