// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler;

import com.klikli_dev.modonomicon.book.PatchouliLink;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import org.jetbrains.annotations.NotNull;

public class PatchouliLinkHandler extends LinkHandler {
    public PatchouliLinkHandler(BookEntryScreen screen) {
        super(screen);
    }

    @Override
    public ClickResult handleClick(@NotNull class_2583 pStyle) {
        var event = pStyle.method_10970();
        if (event == null)
            return ClickResult.UNHANDLED;

        if (event.method_10845() != class_2558.class_2559.field_11748)
            return ClickResult.UNHANDLED;

        if (!PatchouliLink.isPatchouliLink(event.method_10844()))
            return ClickResult.UNHANDLED;

        var link = PatchouliLink.from(event.method_10844());
        if (link.bookId == null)
            return ClickResult.FAILURE;

        BookGuiManager.get().keepMousePosition(() -> {
            BookGuiManager.get().closeScreenStack(this.screen()); //will cause the book to close entirely, and save the open page
            //the integration class handles class loading guards if patchouli is not present
            Services.PATCHOULI.openEntry(link.bookId, link.entryId, link.pageNumber);
        });


        return ClickResult.SUCCESS;
    }
}
